/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.necomm;

public class TEUDPCommInfo {
    public static final int UDP_UNICAST_TYPE = 0;
    public static final int UDP_BROADCAST_TYPE = 1;
    public static final int UDP_MULTICAST_TYPE = 2;
    private String bindAddr = null;
    private int bindPort = -1;
    private String netInfAddr = null;
    private int commType = 0;
    private String userName = null;
    private String password = null;

    public TEUDPCommInfo(int commType, int bindPort) {
        this.commType = commType;
        this.bindPort = bindPort;
    }

    public TEUDPCommInfo(int commType, String bindAddr, int bindPort, String netInfAddr) {
        this.commType = commType;
        this.bindAddr = bindAddr;
        this.bindPort = bindPort;
        this.netInfAddr = netInfAddr;
    }

    TEUDPCommInfo(TEUDPCommInfo info) {
        this.commType = info.commType;
        this.bindAddr = info.bindAddr;
        this.bindPort = info.bindPort;
        this.netInfAddr = info.netInfAddr;
    }

    public int getCommType() {
        return this.commType;
    }

    public void setCommType(int commType) {
        this.commType = commType;
    }

    public String getBindAddr() {
        return this.bindAddr;
    }

    public void setBindAddr(String bindAddr) {
        this.bindAddr = bindAddr;
    }

    public int getBindPort() {
        return this.bindPort;
    }

    public void setBindPort(int bindPort) {
        this.bindPort = bindPort;
    }

    public String getNetInfAddr() {
        return this.netInfAddr;
    }

    public void setNetInfAddr(String netInfAddr) {
        this.netInfAddr = netInfAddr;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TEUDPCommInfo)) {
            return false;
        }
        TEUDPCommInfo commObj = (TEUDPCommInfo)obj;
        if (this.commType != commObj.commType || this.bindPort != commObj.bindPort) {
            return false;
        }
        if (2 != this.commType) {
            return true;
        }
        return null != this.bindAddr && this.bindAddr.equals(commObj.bindAddr) && null != this.netInfAddr && this.netInfAddr.equals(commObj.netInfAddr);
    }

    public int hashCode() {
        int result = 17;
        result += 37 * this.commType;
        result += 37 * this.bindPort;
        if (2 == this.commType) {
            if (null != this.bindAddr) {
                result += 37 * this.bindAddr.hashCode();
            }
            if (null != this.netInfAddr) {
                result += 37 * this.netInfAddr.hashCode();
            }
        }
        return result;
    }

    public String toString() {
        if (2 == this.commType) {
            return "UDP_Multicast[" + this.bindAddr + "," + this.bindPort + "," + this.netInfAddr + "]";
        }
        if (0 == this.commType) {
            return "UDP_Unicast[" + this.bindPort + "]";
        }
        if (1 == this.commType) {
            return "UDP_Broadcast[" + this.bindPort + "]";
        }
        return "INVALID[" + this.bindAddr + "," + this.bindPort + "," + this.netInfAddr + "]";
    }
}

