/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.necomm;

import com.huawei.uflight.necomm.TEPoolableThread;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TEThreadPool {
    static Logger logger = LoggerFactory.getLogger(TEThreadPool.class);
    private List freeThreads = null;
    private List inUseThreads = null;
    private String name = null;

    public TEThreadPool() {
        this("ThreadPool", 2);
    }

    public TEThreadPool(String name, int poolSize) {
        this.name = name;
        this.freeThreads = new LinkedList();
        this.inUseThreads = new LinkedList();
        this.startThreads(poolSize);
        logger.debug(name + " initialized with " + poolSize + " threads.");
    }

    private void startThreads(int poolSize) {
        TEPoolableThread pt = null;
        for (int i = 0; i < poolSize; ++i) {
            pt = new TEPoolableThread(this);
            pt.setName(this.name + "-" + i);
            pt.start();
            this.freeThreads.add(pt);
        }
    }

    public synchronized boolean runTask(Runnable task) {
        if (null == task || this.freeThreads == null) {
            logger.error(this.name + " runTask(" + task + ") failed, task or freeThreads is null.");
            return false;
        }
        while (this.freeThreads.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (null != this.freeThreads) continue;
            logger.error("freeThreads is null, runTask() failed.");
            return false;
        }
        TEPoolableThread t = (TEPoolableThread)this.freeThreads.remove(0);
        this.inUseThreads.add(t);
        t.setTask(task);
        return true;
    }

    synchronized void free(TEPoolableThread t) {
        if (this.inUseThreads != null) {
            this.inUseThreads.remove(t);
            this.freeThreads.add(t);
            this.notifyAll();
        }
    }

    public synchronized void clear() {
        Iterator it = this.freeThreads.iterator();
        while (it.hasNext()) {
            ((TEPoolableThread)it.next()).stopRequest();
        }
        it = this.inUseThreads.iterator();
        while (it.hasNext()) {
            ((TEPoolableThread)it.next()).stopRequest();
        }
        this.freeThreads.clear();
        this.inUseThreads.clear();
        this.freeThreads = null;
        this.inUseThreads = null;
        logger.debug(this.name + " was cleared.");
        this.notifyAll();
    }
}

