/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.necomm;

import com.huawei.uflight.necomm.TECommInfo;
import com.huawei.uflight.necomm.TECommUtils;
import com.huawei.uflight.necomm.TEConnector;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TETCPConnector
implements TEConnector {
    private static Logger logger = LoggerFactory.getLogger(TETCPConnector.class);
    private InetSocketAddress sockAddr = null;
    private Socket socket = null;
    private DataInputStream inStream = null;
    private DataOutputStream outStream = null;
    private String name = null;
    private static final int BUF_SIZE = 16384;

    TETCPConnector() {
    }

    @Override
    public int open(TECommInfo info) {
        String host = info.getAddress().trim();
        int port = info.getPort();
        if (port <= 0 || host == null || "".equals(host)) {
            logger.info(host + ":" + port + " not valid, TCPConnector open failed.");
            return -1;
        }
        this.sockAddr = new InetSocketAddress(host, port);
        if (this.sockAddr.isUnresolved()) {
            logger.info(host + " cannot be resolved, TCPConnector open failed.");
            return -1;
        }
        this.name = "TCPConn[" + host + ":" + port + "]";
        return 0;
    }

    @Override
    public synchronized int connect(int timeout) {
        try {
            if (null == this.socket || this.socket.isClosed()) {
                this.socket = new Socket();
            }
            this.socket.connect(this.sockAddr, timeout);
            this.socket.setTcpNoDelay(true);
            this.socket.setSoTimeout(TECommUtils.parseString2Int(TECommUtils.getSysProperty("TCPSoTimeout"), 30000));
            this.socket.setReceiveBufferSize(16384);
            this.inStream = new DataInputStream(this.socket.getInputStream());
            this.outStream = new DataOutputStream(this.socket.getOutputStream());
            logger.info(this.name + " connect(): OK!, socket receiveBufferSize is" + this.socket.getReceiveBufferSize());
        }
        catch (Exception ex) {
            logger.error(this.name + " connect(): ", (Throwable)ex);
            if (this.socket != null) {
                try {
                    this.socket.close();
                    if (this.inStream != null) {
                        this.inStream.close();
                        this.inStream = null;
                    }
                    if (this.outStream != null) {
                        this.outStream.close();
                        this.outStream = null;
                    }
                }
                catch (IOException e) {
                    logger.error(this.name + " connect() failed in closing the socket.", (Throwable)e);
                }
            }
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int close() {
        try {
            if (this.inStream != null) {
                this.inStream.close();
            }
            if (this.outStream != null) {
                this.outStream.close();
            }
        }
        catch (IOException ex) {
            logger.error(this.name + " close(): ", (Throwable)ex);
            int n = -1;
            return n;
        }
        finally {
            try {
                if (this.socket != null) {
                    this.socket.close();
                    this.socket = null;
                }
            }
            catch (IOException ex) {
                logger.error(this.name + " close(): ", (Throwable)ex);
            }
        }
        this.inStream = null;
        this.outStream = null;
        return 0;
    }

    @Override
    public int sendN(byte[] b, int offset, int length) {
        if (length > 0) {
            logger.info("sendN: offset  " + offset + ", length " + length);
        }
        if (null == this.outStream) {
            logger.error(this.name + " is closed, sendN() failed.");
            return -1;
        }
        try {
            this.outStream.write(b, offset, length);
            this.outStream.flush();
        }
        catch (IOException ex) {
            logger.error(this.name + "sendN(): ", (Throwable)ex);
            return -1;
        }
        return length;
    }

    @Override
    public synchronized int recvN(byte[] b, int offset, int length) {
        if (null == this.inStream) {
            logger.error(this.name + " is closed, recvN() failed.");
            return -1;
        }
        int readSize = 0;
        try {
            readSize = this.inStream.read(b, offset, length);
            logger.info("recvN: offset  " + offset + ", length " + readSize);
        }
        catch (SocketTimeoutException ste) {
            logger.debug(this.name + " received no data, recvN() timed out, return 0.");
            return 0;
        }
        catch (IOException ex) {
            logger.error(this.name + "recvN(): ", (Throwable)ex);
            return -1;
        }
        return readSize;
    }

    @Override
    public int available() throws IOException {
        if (null == this.inStream) {
            logger.error(this.name + " is closed, available() failed.");
            return -1;
        }
        return this.inStream.available();
    }

    public String toString() {
        return this.name;
    }
}

