/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.necomm;

import com.huawei.uflight.necomm.TECommInfo;
import com.huawei.uflight.necomm.TECommUtils;
import com.huawei.uflight.necomm.TEConnector;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.comm.CommPortIdentifier;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TESerialConnector
implements TEConnector {
    private static Logger logger = LoggerFactory.getLogger(TESerialConnector.class);
    private CommPortIdentifier comId = null;
    private SerialPort port = null;
    private DataInputStream inStream = null;
    private DataOutputStream outStream = null;
    private String name = null;
    private int baudrate = 9600;
    private int dataBits = 8;
    private int stopBits = 1;
    private int parity = 0;

    TESerialConnector() {
    }

    @Override
    public int open(TECommInfo info) {
        logger.info("enter open method ");
        this.name = "SerialConn[" + info.getPort() + "]";
        try {
            this.comId = CommPortIdentifier.getPortIdentifier((String)("COM" + info.getPort()));
        }
        catch (NoSuchPortException npe) {
            logger.error(this.name + " no such port.");
            return 0;
        }
        if (null != this.comId && 1 != this.comId.getPortType()) {
            logger.error(this.name + " open() failed: not a serial port.");
            return -1;
        }
        logger.info(this.name + " open() success : ");
        this.baudrate = TECommUtils.parseString2Int(info.getParamValue("baudrate"), 9600);
        this.dataBits = TECommUtils.parseString2Int(info.getParamValue("dataBits"), 8);
        this.stopBits = TECommUtils.parseString2Int(info.getParamValue("stopBits"), 1);
        this.parity = TECommUtils.parseString2Int(info.getParamValue("parity"), 0);
        return 0;
    }

    @Override
    public int connect(int timeout) {
        if (this.port != null) {
            this.port.close();
        }
        if (null == this.comId) {
            return 1;
        }
        try {
            this.port = (SerialPort)this.comId.open("NG LCT", timeout);
            this.port.setSerialPortParams(this.baudrate, this.dataBits, this.stopBits, this.parity);
            this.inStream = new DataInputStream(new BufferedInputStream(this.port.getInputStream()));
            this.outStream = new DataOutputStream(new BufferedOutputStream(this.port.getOutputStream()));
            logger.info(this.name + " connect(): OK!");
        }
        catch (PortInUseException iue) {
            logger.error(this.name + " port:" + this.port + "; connect(): ", (Throwable)iue);
            this.close();
            return 1;
        }
        catch (IOException ie) {
            logger.error(this.name + " connect(): ", (Throwable)ie);
            this.close();
            return 1;
        }
        catch (Exception e) {
            logger.error(this.name + " connect(): ", (Throwable)e);
            this.close();
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int close() {
        try {
            if (this.inStream != null) {
                this.inStream.close();
            }
            if (this.outStream != null) {
                this.outStream.close();
            }
            logger.info(this.name + " close(): OK");
        }
        catch (IOException ex) {
            logger.error(this.name + " close(): ", (Throwable)ex);
            int n = -1;
            return n;
        }
        finally {
            if (this.port != null) {
                this.port.close();
            }
            this.port = null;
        }
        this.inStream = null;
        this.outStream = null;
        return 0;
    }

    @Override
    public int sendN(byte[] b, int offset, int length) {
        if (null == this.outStream) {
            logger.error(this.name + " is closed, sendN() failed.");
            return -1;
        }
        try {
            logger.info("sendN: offset  " + offset + ", length " + length);
            this.outStream.write(b, offset, length);
            this.outStream.flush();
        }
        catch (IOException ex) {
            this.outStream = null;
            logger.error(this.name + " sendN(): ", (Throwable)ex);
            return -1;
        }
        return length;
    }

    @Override
    public int recvN(byte[] b, int offset, int length) {
        if (null == this.inStream) {
            logger.error(this.name + " is closed, recvN() failed.");
            return -1;
        }
        int readSize = 0;
        try {
            readSize = this.inStream.read(b, offset, length);
            logger.info("recvN: offset  " + offset + ", length " + readSize);
        }
        catch (Exception ex) {
            logger.error(this.name + "recvN(): ", (Throwable)ex);
            return -1;
        }
        return readSize;
    }

    @Override
    public int available() throws IOException {
        if (null == this.inStream) {
            logger.error(this.name + " is closed, available() failed.");
            return -1;
        }
        int available = 0;
        available = this.inStream.available();
        return available;
    }

    public String toString() {
        return this.name;
    }
}

