/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.necomm;

import com.huawei.uflight.necomm.TECommInfo;
import com.huawei.uflight.necomm.TECommunicationMgr;
import com.huawei.uflight.necomm.TEConnector;
import com.huawei.uflight.necomm.ssl.Configurator;
import com.huawei.uflight.necomm.ssl.Context;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TESSLTCPConnector
implements TEConnector {
    private static Logger logger = LoggerFactory.getLogger(TESSLTCPConnector.class);
    private InetSocketAddress sockAddr = null;
    private SSLSocket sslSocket = null;
    private DataInputStream inStream = null;
    private DataOutputStream outStream = null;
    private String name = null;
    private static final String IMAP_ROOT_ENV = "IMAP_ROOT";
    private static final String DEPLOYMENT_MODE = "deploymentMode";

    TESSLTCPConnector() {
    }

    @Override
    public int open(TECommInfo info) {
        String host = info.getAddress().trim();
        int port = info.getPort();
        if (port <= 0 || host == null || "".equals(host)) {
            logger.info(host + ":" + port + " not valid, TCPConnector open failed.");
            return -1;
        }
        this.sockAddr = new InetSocketAddress(host, port);
        if (this.sockAddr.isUnresolved()) {
            logger.info(host + " cannot be resolved, TCPConnector open failed.");
            return -1;
        }
        this.name = "TCPConn[" + host + ":" + port + "]";
        return 0;
    }

    @Override
    public int connect(int timeout) {
        try {
            String hostname = this.sockAddr.getAddress().getHostAddress();
            int port = this.sockAddr.getPort();
            String certPath = this.getCertPath();
            logger.info(this.name + " SSL connect(): " + certPath);
            Context context = new Context();
            Configurator config = new Configurator(certPath, "option.xml");
            context.init(config);
            SSLSocketFactory sf = (SSLSocketFactory)context.createSocketFactory();
            this.sslSocket = (SSLSocket)sf.createSocket(hostname, port);
            String[] supported = this.sslSocket.getEnabledCipherSuites();
            this.sslSocket.setEnabledCipherSuites(supported);
            this.inStream = new DataInputStream(new BufferedInputStream(this.sslSocket.getInputStream()));
            this.outStream = new DataOutputStream(new BufferedOutputStream(this.sslSocket.getOutputStream()));
        }
        catch (Exception ex) {
            logger.error(this.name + " SSL connect(): ", (Throwable)ex);
            if (this.sslSocket != null) {
                try {
                    this.sslSocket.close();
                    if (this.inStream != null) {
                        this.inStream.close();
                        this.inStream = null;
                    }
                    if (this.outStream != null) {
                        this.outStream.close();
                        this.outStream = null;
                    }
                }
                catch (IOException e) {
                    logger.error(this.name + " SSL connect() failed in closing the socket.", (Throwable)e);
                }
            }
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int close() {
        try {
            if (this.inStream != null) {
                this.inStream.close();
            }
            if (this.outStream != null) {
                this.outStream.close();
            }
        }
        catch (IOException ex) {
            logger.error(this.name + " close(): ", (Throwable)ex);
            int n = -1;
            return n;
        }
        finally {
            try {
                if (this.sslSocket != null) {
                    this.sslSocket.close();
                    this.sslSocket = null;
                }
            }
            catch (IOException ex) {
                logger.error(this.name + " close(): ", (Throwable)ex);
            }
        }
        this.inStream = null;
        this.outStream = null;
        return 0;
    }

    @Override
    public int sendN(byte[] b, int offset, int length) {
        if (length > 0) {
            logger.info("sendN: offset  " + offset + ", length " + length);
        }
        if (null == this.outStream) {
            logger.error(this.name + " is closed, sendN() failed.");
            return -1;
        }
        try {
            this.outStream.write(b, offset, length);
            this.outStream.flush();
        }
        catch (IOException ex) {
            logger.error(this.name + "sendN(): ", (Throwable)ex);
            return -1;
        }
        return length;
    }

    @Override
    public int recvN(byte[] b, int offset, int length) {
        int actualLength = 0;
        if (null == this.inStream) {
            logger.error(this.name + " is closed, recvN() failed.");
            return -1;
        }
        try {
            actualLength = this.inStream.read(b, offset, length);
        }
        catch (SocketTimeoutException ste) {
            logger.debug(this.name + " received no data, recvN() timed out, return 0.");
            return 0;
        }
        catch (IOException ex) {
            logger.error(this.name + "recvN(): ", (Throwable)ex);
            return -1;
        }
        if (actualLength > 0) {
            logger.info("recvN: offset  " + offset + ", length " + actualLength);
        }
        return actualLength;
    }

    @Override
    public int available() throws IOException {
        if (null == this.inStream) {
            logger.error(this.name + " is closed, available() failed.");
            return -1;
        }
        int avail = 0;
        this.inStream.mark(256);
        this.inStream.read();
        this.inStream.reset();
        avail = this.inStream.available();
        logger.info("available(): " + avail);
        return avail;
    }

    public String toString() {
        return this.name;
    }

    private String getCertPath() {
        String deployModeProp = System.getProperty(DEPLOYMENT_MODE);
        boolean isIntegratedDeployment = null == deployModeProp ? false : DeploymentMode.integrated.toString().equalsIgnoreCase(deployModeProp.trim());
        String filePath = "";
        if (isIntegratedDeployment) {
            String imapRootEnv = System.getenv(IMAP_ROOT_ENV);
            filePath = imapRootEnv + TECommunicationMgr.instance().getCertPath();
        } else {
            filePath = "conf" + File.separator + "certificate";
        }
        return filePath;
    }

    private static enum DeploymentMode {
        integrated,
        independent;

    }
}

