/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.necomm;

import com.huawei.uflight.necomm.TEThreadPool;

class TEPoolableThread
extends Thread {
    private Runnable task = null;
    private TEThreadPool pool = null;
    private boolean stopRequested = false;

    TEPoolableThread(TEThreadPool pool) {
        this.pool = pool;
    }

    synchronized void stopRequest() {
        this.stopRequested = true;
        this.notifyAll();
    }

    synchronized void setTask(Runnable task) {
        this.task = task;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        while (true) {
            Runnable assignedTask = null;
            TEPoolableThread tEPoolableThread = this;
            synchronized (tEPoolableThread) {
                while (null == this.task && !this.stopRequested) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ie) {
                        TEThreadPool.logger.debug(this.getName() + " interrupted.");
                    }
                }
                if (this.task == null) {
                    // MONITOREXIT @DISABLED, blocks:[4, 9, 11] lbl13 : MonitorExitStatement: MONITOREXIT : var2_2
                    TEThreadPool.logger.debug(this.getName() + " exit");
                    return;
                }
                assignedTask = this.task;
            }
            TEThreadPool.logger.info(this.getName() + " is doing the newly assigned task " + assignedTask);
            try {
                assignedTask.run();
                continue;
            }
            catch (Exception e) {
                TEThreadPool.logger.error(this.getName() + " caught an exception while doing the task " + assignedTask, (Throwable)e);
                continue;
            }
            finally {
                this.task = null;
                this.pool.free(this);
                TEThreadPool.logger.info(this.getName() + " is freed.");
                continue;
            }
            break;
        }
    }
}

