/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.necomm;

import com.huawei.uflight.necomm.TEMessageBlock;
import java.util.Date;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TEMessageQueue {
    private static Logger logger = LoggerFactory.getLogger(TEMessageQueue.class);
    private LinkedBlockingQueue<TEMessageBlock> queue;
    private TimedoutMsgTask timerTask = null;
    private String name = null;

    public TEMessageQueue(int capacity) {
        this.name = this.getClass().getSimpleName() + "[" + System.currentTimeMillis() + "]" + "[" + new Date() + "]";
        this.queue = new LinkedBlockingQueue(capacity);
    }

    public TEMessageQueue() {
        this(Integer.MAX_VALUE);
    }

    public TEMessageQueue(String name, Timer timer) {
        this.name = name;
        this.queue = new LinkedBlockingQueue();
        this.startTimerTask(timer);
    }

    public void startTimerTask(Timer timer) {
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
        if (timer != null) {
            this.timerTask = new TimedoutMsgTask();
            timer.scheduleAtFixedRate((TimerTask)this.timerTask, 1L, 1000L);
        }
    }

    public int enqueue(TEMessageBlock msg) {
        if (msg == null) {
            logger.info(this.name + " enqueue(): message is null, return -1.");
            return -1;
        }
        try {
            this.queue.put(msg);
            return this.queue.size();
        }
        catch (Exception e) {
            logger.error("failed to enqueue: ", (Throwable)e);
            return -1;
        }
    }

    public TEMessageBlock dequeue() {
        try {
            return this.queue.take();
        }
        catch (Exception e) {
            logger.error("dequeue error ", (Throwable)e);
            return null;
        }
    }

    public synchronized int getSize() {
        return this.queue.size();
    }

    public synchronized void clear() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
        this.queue.clear();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.name);
        int MAX = 20;
        sb.append(", current capacity = ").append(this.queue.size());
        sb.append(", remaining capactity = ").append(this.queue.remainingCapacity());
        sb.append(", [");
        Iterator<TEMessageBlock> itr = this.queue.iterator();
        for (int count = 20; itr.hasNext() && count > 0; --count) {
            sb.append(itr.next().toString());
            sb.append(", ");
        }
        if (this.queue.size() > 20) {
            sb.append(" ...... too many element, unabled to print all");
        }
        sb.append(']');
        return sb.toString();
    }

    private class TimedoutMsgTask
    extends TimerTask {
        private TimedoutMsgTask() {
        }

        @Override
        public void run() {
            Iterator itr = TEMessageQueue.this.queue.iterator();
            while (itr.hasNext()) {
                TEMessageBlock mb = (TEMessageBlock)itr.next();
                if (mb.getExpireTime() == 0 || mb.decExpireTime() > 0) continue;
                logger.info(TEMessageQueue.this.name + " found an expired message = " + mb);
                itr.remove();
            }
        }
    }
}

