/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.necomm;

import com.huawei.uflight.necomm.TECommConnection;
import com.huawei.uflight.necomm.TECommInfo;
import com.huawei.uflight.necomm.TECommUtils;
import com.huawei.uflight.necomm.TECommunicationMgr;
import com.huawei.uflight.necomm.TEConnector;
import com.huawei.uflight.necomm.TEInputDataReceiver;
import com.huawei.uflight.necomm.TEMessageBlock;
import com.huawei.uflight.necomm.TEMessageQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TEIOHandler {
    private static Logger logger = LoggerFactory.getLogger(TEIOHandler.class);
    private volatile boolean isInReading = false;
    private volatile boolean isInWriting = false;
    private Object isInReadingMutex = new Object();
    private Object isInWritingMutex = new Object();
    private volatile boolean canIOMark = false;
    private volatile int connectState = -1;
    private final Object connectStateMutex = new Object();
    private byte[] messageBuffer = null;
    private TEConnector connector = null;
    private TEInputDataReceiver dataReceiver = null;
    private TEMessageQueue messageQueue = null;
    private int connectCounter = 0;
    private Runnable connectExecution = new Runnable(){

        @Override
        public void run() {
            TEIOHandler.this.connect(TECommunicationMgr.instance().getConnectTimeout());
        }
    };
    private ConnectStateTask connectStateTask = null;
    private String name = null;
    private List connectionObjList = null;

    protected TEIOHandler(TEConnector connector, TEInputDataReceiver dataReceiver) {
        this.connector = connector;
        this.dataReceiver = dataReceiver;
        this.messageBuffer = new byte[dataReceiver.getMaxPacketLength()];
        this.name = "IOHandler[" + connector + "]";
        this.connectionObjList = new ArrayList();
        this.messageQueue = new TEMessageQueue("queue[" + connector + "]", TECommunicationMgr.instance().getTimer());
        this.connectStateTask = new ConnectStateTask();
        int checkConnStatePeriod = TECommUtils.parseString2Int(TECommUtils.getSysProperty("checkConnStatePeriod"), 5);
        TECommunicationMgr.instance().getTimer().schedule((TimerTask)this.connectStateTask, (long)checkConnStatePeriod * 1000L, (long)checkConnStatePeriod * 1000L);
        this.connectState = 1;
    }

    public TEConnector getConnector() {
        return this.connector;
    }

    protected int put(TEMessageBlock mb) {
        return this.messageQueue.enqueue(mb);
    }

    protected int putHead(TEMessageBlock mb) {
        byte[] data = (byte[])mb.getObj();
        if (this.canIOMark) {
            if (this.connector.sendN(data, 0, data.length) < 0) {
                logger.error(this.name + " send data error, reenqueue the message= " + new String(data));
                this.handleException("write error");
                return -1;
            }
            return 0;
        }
        return -1;
    }

    protected TEMessageBlock get() {
        return this.messageQueue.dequeue();
    }

    int getConnectState() {
        return this.connectState;
    }

    int connect(int timeout) {
        logger.info(this.name + " connect(): old state is " + TECommUtils.getConState(this.connectState));
        if (this.canIOMark) {
            logger.info(this.name + "another thread already connect");
            return 0;
        }
        int maxConnectCount = TECommunicationMgr.instance().getMaxConnectCount();
        if (maxConnectCount != -1 && this.connectCounter >= maxConnectCount) {
            this.connectCounter = 0;
            this.connectStateTask.resume();
            logger.debug("connect(): connectStateTask was resumed.");
        }
        logger.info(this.name + " is trying to connect...");
        int connectResult = -1;
        connectResult = this.connector.connect(timeout * 1000);
        if (0 == connectResult) {
            this.canIOMark = true;
            this.connectCounter = 0;
            this.notifyConnectState(connectResult);
        } else {
            ++this.connectCounter;
            if (maxConnectCount != -1 && this.connectCounter >= maxConnectCount) {
                this.connectStateTask.suspend();
                logger.debug("connect counter reached the max count, connectStateTask was suspended.");
            }
        }
        this.connectState = connectResult;
        return connectResult;
    }

    public void setConnectState(int state) {
        this.connectState = state;
    }

    private void clear() {
        this.connectStateTask.cancel();
        this.messageQueue.clear();
        this.connectionObjList.clear();
    }

    private void sendCloseMessage() {
        TEMessageBlock closeMsg = new TEMessageBlock(-1, null, 0);
        this.putHead(closeMsg);
    }

    public int close(boolean closeImmediately) {
        return this.close(closeImmediately, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int close(boolean closeImmediately, boolean clear) {
        int result = -1;
        Object object = this.connectStateMutex;
        synchronized (object) {
            logger.debug(this.name + " close(): old state is " + TECommUtils.getConState(this.connectState));
            if (-1 != this.connectState && !closeImmediately) {
                this.connectStateTask.suspend();
                this.sendCloseMessage();
                logger.info("send close message: " + this.messageQueue.toString());
                return 0;
            }
            result = this.connectState;
            if (result == -1) {
                return 0;
            }
        }
        logger.info(this.name + " close(): trying to close... closeImmediately =" + closeImmediately + " clear = " + clear);
        this.connectStateTask.suspend();
        result = 0 == this.connectState ? this.disconnect() : 0;
        this.connectState = -1;
        this.notifyConnectState(-1);
        if (clear) {
            this.clear();
        }
        return result;
    }

    private int disconnect() {
        logger.info(this.name + " is disconnecting...");
        this.canIOMark = false;
        int result = -1;
        if (this.connector != null) {
            result = this.connector.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleInputData() throws IOException {
        Object object = this.isInReadingMutex;
        synchronized (object) {
            if (!this.canIOMark || this.isInReading) {
                return;
            }
            this.isInReading = true;
        }
        int readPos = 0;
        int headLength = this.dataReceiver.getHeadLength();
        int actualLength = 0;
        int frameLength = 0;
        int packetLength = 0;
        int msgLength = 0;
        while (this.canIOMark) {
            int len = this.connector.recvN(this.messageBuffer, readPos, headLength);
            if (len < 0) {
                this.handleException("Read Error, packet head len=" + len);
                break;
            }
            if (len < headLength) {
                headLength -= len;
                readPos += len;
                continue;
            }
            readPos = this.dataReceiver.getHeadLength();
            headLength = this.dataReceiver.getHeadLength();
            frameLength = actualLength = this.dataReceiver.getFrameLength(this.messageBuffer);
            while (frameLength >= 0) {
                len = this.connector.recvN(this.messageBuffer, readPos, frameLength);
                if (len < 0) {
                    this.handleException("Read Error, frame len=" + len);
                    break;
                }
                if (len < frameLength) {
                    frameLength -= len;
                    readPos += len;
                    continue;
                }
                frameLength = -1;
                packetLength = this.dataReceiver.getHeadLength() + actualLength;
                logger.info(this.name + " read " + packetLength + " bytes.");
                if (logger.isDebugEnabled()) {
                    logger.debug(this.name + "read data = <<<..." + new String(this.messageBuffer, 0, packetLength));
                }
                if (-1 == (msgLength = this.dataReceiver.checkMessageValid(this.messageBuffer, 0, packetLength, this.getCommInfo()))) {
                    logger.info(this.name + " checkMessageValid()=" + msgLength + ", data cannot be recongnized and will be discarded.");
                    this.handleException("read invalid data");
                    Object object2 = this.isInReadingMutex;
                    synchronized (object2) {
                        this.isInReading = false;
                    }
                    return;
                }
                if (-2 != msgLength) continue;
                logger.info(this.name + " checkMessageValid()=" + msgLength + ", more data expected.");
                break;
            }
            readPos = 0;
        }
        Object object3 = this.isInReadingMutex;
        synchronized (object3) {
            this.isInReading = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleInput() {
        try {
            this.handleInputData();
        }
        catch (Exception e) {
            logger.error("handleinput exception", (Throwable)e);
            this.handleException("read invalid data");
            Object object = this.isInReadingMutex;
            synchronized (object) {
                this.isInReading = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleOutput() {
        Object object = this.isInWritingMutex;
        synchronized (object) {
            if (!this.canIOMark || this.isInWriting) {
                return;
            }
            if (this.messageQueue.getSize() <= 0) {
                return;
            }
            this.isInWriting = true;
        }
        TEMessageBlock mb = null;
        while (this.messageQueue.getSize() > 0 && null != (mb = this.get())) {
            if (-1 == mb.getType()) {
                logger.debug(this.name + " got an close message, closing...");
                TECommunicationMgr mgr = TECommunicationMgr.instance();
                if (mgr != null) {
                    mgr.removeIOHandler(this);
                }
                this.close(true);
                break;
            }
            byte[] data = (byte[])mb.getObj();
            if (!this.canIOMark) continue;
            if (this.connector.sendN(data, 0, data.length) < 0) {
                logger.error(this.name + " send data error, reenqueue the message= " + new String(data));
                this.handleException("write error");
                break;
            }
            logger.info(this.name + " send " + data.length + " bytes.");
            logger.debug(this.name + " send data = " + new String(data));
        }
        Object object2 = this.isInWritingMutex;
        synchronized (object2) {
            this.isInWriting = false;
        }
    }

    private void notifyConnectState(int state) {
        logger.info(this.name + " connect state changed to " + TECommUtils.getConState(state));
        ArrayList tempObjList = new ArrayList(this.connectionObjList.size());
        tempObjList.addAll(this.connectionObjList);
        for (int i = tempObjList.size() - 1; i >= 0; --i) {
            try {
                ((TECommConnection)tempObjList.get(i)).connectStateChanged(state);
                continue;
            }
            catch (Exception e) {
                logger.info("handle connectstate change exception", (Throwable)e);
            }
        }
    }

    private void handleException(String errorText) {
        logger.error(this.name + " handleException(): " + errorText);
        this.connectStateTask.suspend();
        this.disconnect();
        this.connectState = 1;
        this.notifyConnectState(1);
        this.connectStateTask.resume();
    }

    boolean addConnectionObj(TECommConnection obj) {
        if (null == obj) {
            return false;
        }
        if (this.connectionObjList.contains(obj)) {
            return false;
        }
        this.connectionObjList.add(obj);
        obj.connectStateChanged(this.connectState);
        return true;
    }

    boolean removeConnectionObj(TECommConnection obj) {
        if (null == obj) {
            return false;
        }
        return this.connectionObjList.remove(obj);
    }

    boolean noConnectionObj() {
        return this.connectionObjList.isEmpty();
    }

    public String toString() {
        return this.name;
    }

    private TECommInfo getCommInfo() {
        return TECommunicationMgr.instance().getCommInfoByHandler(this);
    }

    class ConnectStateTask
    extends TimerTask {
        private volatile boolean isSuspended = false;

        ConnectStateTask() {
        }

        @Override
        public void run() {
            logger.info(TEIOHandler.this.name + " is trying to ConnectStateTask, connectState =" + TEIOHandler.this.connectState + "canIOMark = " + TEIOHandler.this.canIOMark + " isSuspended = " + this.isSuspended);
            if (TEIOHandler.this.canIOMark || this.isSuspended) {
                return;
            }
            TECommunicationMgr.instance().runTask(TEIOHandler.this.connectExecution);
        }

        void suspend() {
            this.isSuspended = true;
        }

        void resume() {
            this.isSuspended = false;
        }
    }
}

