/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.necomm;

import com.huawei.uflight.necomm.TECommConnection;
import com.huawei.uflight.necomm.TECommData;
import com.huawei.uflight.necomm.TECommInfo;
import com.huawei.uflight.necomm.TECommUtils;
import com.huawei.uflight.necomm.TEConnector;
import com.huawei.uflight.necomm.TEIOHandler;
import com.huawei.uflight.necomm.TEInputDataReceiver;
import com.huawei.uflight.necomm.TEMessageBlock;
import com.huawei.uflight.necomm.TESSLTCPConnector;
import com.huawei.uflight.necomm.TESerialConnector;
import com.huawei.uflight.necomm.TETCPConnector;
import com.huawei.uflight.necomm.TETP4Connector;
import com.huawei.uflight.necomm.TEThreadPool;
import com.huawei.uflight.necomm.TEUDPCommInfo;
import com.huawei.uflight.necomm.TEUDPHandler;
import com.huawei.uflight.necomm.osgi.NECommActivator;
import com.huawei.uflight.qxprotocol.qx5adapter.TEQxCommuMgr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TECommunicationMgr {
    private static TECommunicationMgr instanceObj = null;
    private Map<TECommInfo, TEIOHandler> ioHandlerMap = null;
    private List<TEIOHandler> ioHandlerList = null;
    private int nextIOHandler = 0;
    private volatile boolean closedFlag = true;
    private String certPath = "/etc/ssl";
    private int inputThreadNum = TECommUtils.parseString2Int(TECommUtils.getSysProperty("inputThreadNum"), 3);
    private int outputThreadNum = TECommUtils.parseString2Int(TECommUtils.getSysProperty("outputThreadNum"), 2);
    private int connectTimeout = 10;
    private int maxConnectCount = -1;
    private InputThread[] inputThreads = null;
    private OutputThread[] outputThreads = null;
    private TEThreadPool connectThreadPool = null;
    private Timer timer = null;
    private Map udpHandlerMap = null;
    static Logger logger = LoggerFactory.getLogger(TECommunicationMgr.class);

    private TECommunicationMgr() {
        if (NECommActivator.isIntegratedMode()) {
            this.inputThreadNum = 32;
            this.outputThreadNum = 1;
        } else {
            this.inputThreadNum = 32;
        }
        this.connectTimeout = TECommUtils.parseString2Int(TECommUtils.getSysProperty("connectTimeout"), 10);
        this.maxConnectCount = TECommUtils.parseString2Int(TECommUtils.getSysProperty("maxConnectCount"), -1);
        this.ioHandlerMap = new HashMap<TECommInfo, TEIOHandler>();
        this.ioHandlerList = new ArrayList<TEIOHandler>();
        this.inputThreads = new InputThread[this.inputThreadNum];
        this.outputThreads = new OutputThread[this.outputThreadNum];
        this.timer = new Timer();
        this.connectThreadPool = new TEThreadPool("connectThreadPool", TECommUtils.parseString2Int(TECommUtils.getSysProperty("connectThreadNum"), 3));
        this.udpHandlerMap = new HashMap();
        this.closedFlag = false;
        this.extraInit();
        logger.debug("TECommunicationMgr initialized with " + this.inputThreadNum + " input threads and " + this.outputThreadNum + " output threads.");
    }

    private void extraInit() {
        int i;
        for (i = 0; i < this.inputThreadNum; ++i) {
            this.inputThreads[i] = new InputThread();
            this.inputThreads[i].setName("inputThread" + i);
            this.inputThreads[i].start();
        }
        for (i = 0; i < this.outputThreadNum; ++i) {
            this.outputThreads[i] = new OutputThread();
            this.outputThreads[i].setName("outputThread" + i);
            this.outputThreads[i].start();
        }
    }

    public static synchronized TECommunicationMgr instance() {
        if (null == instanceObj) {
            instanceObj = new TECommunicationMgr();
        }
        return instanceObj;
    }

    Timer getTimer() {
        return this.timer;
    }

    int getConnectTimeout() {
        return this.connectTimeout;
    }

    int getMaxConnectCount() {
        return this.maxConnectCount;
    }

    void runTask(Runnable task) {
        this.connectThreadPool.runTask(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        int i;
        logger.debug("closing TECommunicationMgr...");
        this.closedFlag = true;
        this.connectThreadPool.clear();
        for (i = 0; i < this.inputThreadNum; ++i) {
            this.inputThreads[i].stopRequest();
        }
        for (i = 0; i < this.outputThreadNum; ++i) {
            this.outputThreads[i].stopRequest();
        }
        Object object = this.ioHandlerMap;
        synchronized (object) {
            int size = this.ioHandlerList.size();
            for (int i2 = 0; i2 < size; ++i2) {
                TEIOHandler handler = this.ioHandlerList.get(i2);
                handler.close(true);
            }
            this.ioHandlerMap.clear();
            this.ioHandlerList.clear();
        }
        object = this.udpHandlerMap;
        synchronized (object) {
            for (TEUDPHandler handler : this.udpHandlerMap.values()) {
                handler.close();
            }
            this.udpHandlerMap.clear();
        }
        this.timer.cancel();
        object = TECommunicationMgr.class;
        synchronized (TECommunicationMgr.class) {
            instanceObj = null;
            // ** MonitorExit[var1_2] (shouldn't be in output)
            logger.debug("TECommunicationMgr closed.");
            return;
        }
    }

    public int connect(TECommInfo info, TECommConnection obj, TEInputDataReceiver receiver) {
        return this.connect(info, obj, receiver, this.connectTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int connect(TECommInfo info, TECommConnection obj, TEInputDataReceiver receiver, int timeout) {
        if (null == info || null == obj || null == receiver) {
            logger.error("connect() failed: the param info or obj or receiver is null.");
            return -2;
        }
        TEIOHandler handler = null;
        TEConnector connector = null;
        Map<TECommInfo, TEIOHandler> map = this.ioHandlerMap;
        synchronized (map) {
            handler = this.ioHandlerMap.get(info);
            int commType = info.getCommType();
            logger.debug("found handler for " + info + " = " + handler);
            if (null == handler) {
                if (0 == commType) {
                    connector = new TETCPConnector();
                } else if (1 == commType) {
                    connector = new TETP4Connector();
                } else if (2 == commType) {
                    connector = new TESerialConnector();
                } else if (4 == commType) {
                    connector = new TESSLTCPConnector();
                } else {
                    logger.info("connect(" + info + ") failed, commType: " + commType + " is not valid");
                    return -2;
                }
                if (connector.open(info) < 0) {
                    return -2;
                }
                handler = new TEIOHandler(connector, receiver);
                this.ioHandlerMap.put(new TECommInfo(info), handler);
                this.ioHandlerList.add(handler);
                logger.info(handler + " successfully created!");
            }
        }
        handler.addConnectionObj(obj);
        return handler.connect(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send(TECommInfo info, byte[] b, int timeout) {
        TEMessageBlock mb = new TEMessageBlock(b, timeout > 0 ? timeout : 0);
        TEIOHandler handler = null;
        Map<TECommInfo, TEIOHandler> map = this.ioHandlerMap;
        synchronized (map) {
            handler = this.ioHandlerMap.get(info);
        }
        if (null == handler) {
            logger.error("send a message to " + info + " failed, handler not found: " + new String(b));
            return -1;
        }
        logger.debug("send a message to " + handler + ": " + new String(b));
        return handler.put(mb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendUrgent(TECommInfo info, byte[] b, int timeout) {
        TEMessageBlock mb = new TEMessageBlock(b, timeout > 0 ? timeout : 0);
        TEIOHandler handler = null;
        Map<TECommInfo, TEIOHandler> map = this.ioHandlerMap;
        synchronized (map) {
            handler = this.ioHandlerMap.get(info);
        }
        if (null == handler) {
            logger.error("send a message to " + info + " failed, handler not found: " + new String(b));
            return -1;
        }
        logger.debug("send a message to " + handler);
        return handler.putHead(mb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int close(TECommInfo info, TECommConnection obj, boolean closeImmediately) {
        TEIOHandler handler = null;
        Map<TECommInfo, TEIOHandler> map = this.ioHandlerMap;
        synchronized (map) {
            handler = this.ioHandlerMap.get(info);
            if (null == handler) {
                logger.error("close " + info + " failed, handler not found");
                return -1;
            }
            handler.removeConnectionObj(obj);
            if (!handler.noConnectionObj()) {
                logger.info("close " + info + " : not closed, noConnectionObj is false");
                return 1;
            }
            this.ioHandlerMap.remove(info);
            TEQxCommuMgr.instance().getCommPortMaps().remove(info);
            if (closeImmediately) {
                this.ioHandlerList.remove(handler);
            }
        }
        return handler.close(closeImmediately);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeIOHandler(TEIOHandler handler) {
        Map<TECommInfo, TEIOHandler> map = this.ioHandlerMap;
        synchronized (map) {
            this.ioHandlerList.remove(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnectState(TECommInfo info) {
        TEIOHandler handler = null;
        Map<TECommInfo, TEIOHandler> map = this.ioHandlerMap;
        synchronized (map) {
            handler = this.ioHandlerMap.get(info);
        }
        if (null != handler) {
            return handler.getConnectState();
        }
        return -2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int connect(TEUDPCommInfo info) {
        TEUDPHandler handler = null;
        int result = -2;
        Map map = this.udpHandlerMap;
        synchronized (map) {
            handler = (TEUDPHandler)this.udpHandlerMap.get(info);
            if (null == handler) {
                handler = new TEUDPHandler();
                result = handler.open(info);
                if (-1 == result) {
                    return -2;
                }
                this.udpHandlerMap.put(new TEUDPCommInfo(info), handler);
            } else {
                result = handler.getConnectState();
                if (result != 0) {
                    result = handler.open(info);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send(TEUDPCommInfo info, TECommData data) {
        TEUDPHandler handler = null;
        Map map = this.udpHandlerMap;
        synchronized (map) {
            handler = (TEUDPHandler)this.udpHandlerMap.get(info);
        }
        if (null == handler) {
            logger.error("send a message to " + info + " failed, handler not found: " + data);
            return -1;
        }
        logger.debug("send a message to " + handler);
        return handler.send(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TECommData recv(TEUDPCommInfo info) {
        TEUDPHandler handler = null;
        Map map = this.udpHandlerMap;
        synchronized (map) {
            handler = (TEUDPHandler)this.udpHandlerMap.get(info);
        }
        if (null == handler) {
            logger.error("recv a message from " + info + " failed, handler not found");
            return null;
        }
        return handler.recv();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(TEUDPCommInfo info) {
        TEUDPHandler handler = null;
        Map map = this.udpHandlerMap;
        synchronized (map) {
            handler = (TEUDPHandler)this.udpHandlerMap.remove(info);
        }
        if (null != handler) {
            handler.close();
        } else {
            logger.error("close " + info + " failed: handler not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnectState(TEUDPCommInfo info) {
        TEUDPHandler handler = null;
        Map map = this.udpHandlerMap;
        synchronized (map) {
            handler = (TEUDPHandler)this.udpHandlerMap.get(info);
        }
        if (null != handler) {
            return handler.getConnectState();
        }
        return -2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TEIOHandler nextHandler() {
        if (this.closedFlag) {
            return null;
        }
        TEIOHandler handler = null;
        Map<TECommInfo, TEIOHandler> map = this.ioHandlerMap;
        synchronized (map) {
            if (!this.ioHandlerList.isEmpty()) {
                if (this.nextIOHandler >= this.ioHandlerList.size()) {
                    this.nextIOHandler = 0;
                }
                handler = this.ioHandlerList.get(this.nextIOHandler);
                ++this.nextIOHandler;
            }
        }
        return handler;
    }

    public static List getLocalAddrList() {
        return TECommUtils.getLocalAddrList();
    }

    public static List getSerialPortList() {
        return TECommUtils.getSerialPortList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TECommInfo getCommInfoByHandler(TEIOHandler handler) {
        Map<TECommInfo, TEIOHandler> map = this.ioHandlerMap;
        synchronized (map) {
            for (Map.Entry<TECommInfo, TEIOHandler> ioHandlerEntry : this.ioHandlerMap.entrySet()) {
                if (ioHandlerEntry.getValue() != handler) continue;
                return ioHandlerEntry.getKey();
            }
        }
        return null;
    }

    public void setCertPath(String certPath) {
        this.certPath = certPath;
    }

    public String getCertPath() {
        return this.certPath;
    }

    class OutputThread
    extends Thread {
        private boolean stopRequested = false;

        OutputThread() {
        }

        void stopRequest() {
            this.stopRequested = true;
        }

        @Override
        public void run() {
            while (true) {
                TEIOHandler handler;
                if (null != (handler = TECommunicationMgr.this.nextHandler())) {
                    try {
                        handler.handleOutput();
                    }
                    catch (Exception e) {
                        logger.error(this.getName() + " caught an exception while handling output, thread will continue.", (Throwable)e);
                    }
                }
                if (this.stopRequested) break;
                try {
                    OutputThread.sleep(1L);
                }
                catch (InterruptedException ie) {
                    logger.debug(this.getName() + " has been interrupted.");
                }
            }
        }
    }

    class InputThread
    extends Thread {
        private boolean stopRequested = false;

        InputThread() {
        }

        void stopRequest() {
            this.stopRequested = true;
        }

        @Override
        public void run() {
            while (true) {
                TEIOHandler handler;
                if (null != (handler = TECommunicationMgr.this.nextHandler())) {
                    try {
                        handler.handleInput();
                    }
                    catch (Exception e) {
                        logger.error(this.getName() + " caught an exception while handling input, thread will continue.", (Throwable)e);
                    }
                }
                if (this.stopRequested) break;
                try {
                    InputThread.sleep(1L);
                }
                catch (InterruptedException ie) {
                    logger.debug(this.getName() + " has been interrupted.");
                }
            }
        }
    }
}

