/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.necomm;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.comm.CommPortIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TECommUtils {
    private static Logger logger = LoggerFactory.getLogger(TECommUtils.class);
    static Properties neCommCfg = new Properties();

    private TECommUtils() {
    }

    static List getLocalAddrList() {
        ArrayList<String> addrList = new ArrayList<String>(5);
        try {
            Enumeration<NetworkInterface> netInfEnum = NetworkInterface.getNetworkInterfaces();
            Enumeration<InetAddress> addrEnum = null;
            InetAddress addr = null;
            while (netInfEnum.hasMoreElements()) {
                NetworkInterface ni = netInfEnum.nextElement();
                addrEnum = ni.getInetAddresses();
                while (addrEnum.hasMoreElements()) {
                    addr = addrEnum.nextElement();
                    if (addr.isLoopbackAddress() || addrList.contains(addr.getHostAddress())) continue;
                    addrList.add(addr.getHostAddress());
                }
            }
        }
        catch (Exception e) {
            logger.error("getLocalAddrList()" + e);
        }
        return addrList;
    }

    static List getSerialPortList() {
        ArrayList<String> portList = new ArrayList<String>(5);
        Enumeration portEnum = CommPortIdentifier.getPortIdentifiers();
        while (portEnum.hasMoreElements()) {
            CommPortIdentifier portId = (CommPortIdentifier)portEnum.nextElement();
            if (1 != portId.getPortType()) continue;
            portList.add(portId.getName());
        }
        return portList;
    }

    static String getCommType(int commType) {
        String result;
        switch (commType) {
            case 0: {
                result = "TCP";
                break;
            }
            case 1: {
                result = "TP4";
                break;
            }
            case 2: {
                result = "SERIAL";
                break;
            }
            case 3: {
                result = "UDP";
                break;
            }
            default: {
                result = "Invalid";
            }
        }
        return result;
    }

    static String getConState(int conState) {
        String result;
        switch (conState) {
            case -1: {
                result = "CLOSED";
                break;
            }
            case 0: {
                result = "CONNECTED";
                break;
            }
            case 1: {
                result = "DISCONNECTED";
                break;
            }
            case 2: {
                result = "CONNECTING";
                break;
            }
            case 3: {
                result = "DISCONNECTING";
                break;
            }
            case -2: {
                result = "UNINITIALIZED";
                break;
            }
            default: {
                result = "Invalid";
            }
        }
        return result;
    }

    static String getSysProperty(String key) {
        return neCommCfg.getProperty(key);
    }

    static int parseString2Int(String value, int defaultValue) {
        int tempInt = defaultValue;
        if (value != null) {
            try {
                tempInt = Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                logger.error("Property <" + value + "> not defined.");
                tempInt = defaultValue;
            }
        }
        return tempInt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream in = null;
        try {
            in = new FileInputStream(new File("conf/necomm.cfg").getAbsoluteFile());
            neCommCfg.load(in);
        }
        catch (IOException ex) {
            logger.error("Load necomm.cfg fail!" + ex);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error("Close file stream fail!" + e);
                }
            }
        }
    }
}

