/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.necomm;

import com.huawei.uflight.necomm.TECommUtils;

public class TECommInfo {
    public static final int COMM_TCP_TYPE = 0;
    public static final int COMM_TP4_TYPE = 1;
    public static final int COMM_SERIAL_TYPE = 2;
    public static final int COMM_UDP_TYPE = 3;
    public static final int COMM_SSLTCP_TYPE = 4;
    private int commType = 0;
    private String address = null;
    private int port = -1;
    private String[][] params = null;

    public TECommInfo(int commType, String address) {
        this(commType, address, -1);
    }

    public TECommInfo(int commType, String address, int port) {
        this.commType = commType;
        if (null == address) {
            address = "";
        }
        this.address = address;
        this.port = port;
    }

    public TECommInfo(int commType, String address, int port, String[][] params) {
        this.commType = commType;
        if (null == address) {
            address = "";
        }
        this.address = address;
        this.port = port;
        this.params = params;
    }

    TECommInfo(TECommInfo info) {
        this.commType = info.commType;
        this.address = info.address;
        this.port = info.port;
    }

    public int getCommType() {
        return this.commType;
    }

    public void setCommType(int commType) {
        this.commType = commType;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setParams(String[][] params) {
        this.params = params;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String[][] getParams() {
        return this.params;
    }

    public String getParamValue(String key) {
        String value = null;
        if (null == this.params || null == key) {
            return value;
        }
        for (int i = this.params.length - 1; i >= 0; --i) {
            if (this.params[i] == null || this.params[i].length <= 1 || !key.equalsIgnoreCase(this.params[i][0])) continue;
            value = this.params[i][1];
            break;
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TECommInfo)) {
            return false;
        }
        TECommInfo commObj = (TECommInfo)obj;
        if (this.commType != commObj.commType) {
            return false;
        }
        switch (this.commType) {
            case 2: {
                return this.address.equals(commObj.address);
            }
        }
        return this.address.equals(commObj.address) && this.port == commObj.port;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.commType;
        result = 37 * result + this.address.hashCode();
        if (this.commType != 2) {
            result = 37 * result + this.port;
        }
        return result;
    }

    public String toString() {
        if (2 == this.commType) {
            return "TECommInfo[" + TECommUtils.getCommType(this.commType) + "-" + this.address + "]";
        }
        return "TECommInfo[" + TECommUtils.getCommType(this.commType) + "-" + this.address + ":" + this.port + "]";
    }
}

