/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.necomm;

import java.io.ByteArrayOutputStream;
import java.util.Locale;
import org.slf4j.LoggerFactory;

public final class IOStreamConvertor {
    public static final String DATA_SEPARATOR = " ";
    public static final String BLANK_DATA = "  ";
    public static final String DASH_LINE = " ---  ";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private IOStreamConvertor() {
    }

    public static int swapLong(int L) {
        return IOStreamConvertor.swapWord(L & 0xFFFF) << 16 | IOStreamConvertor.swapWord(L >> 16 & 0xFFFF);
    }

    public static int swapWord(int L) {
        return (L & 0xFF) << 8 | (L & 0xFF00) >> 8;
    }

    public static int ntohl(int L) {
        return IOStreamConvertor.swapLong(L);
    }

    public static int ntohs(int L) {
        return IOStreamConvertor.swapWord(L);
    }

    public static int htonl(int L) {
        return IOStreamConvertor.swapLong(L);
    }

    public static int htons(int L) {
        return IOStreamConvertor.swapWord(L);
    }

    public static byte[] int2Bytes(int a) {
        byte[] b = new byte[]{(byte)(a >> 24 & 0xFF), (byte)(a >> 16 & 0xFF), (byte)(a >> 8 & 0xFF), (byte)(a & 0xFF)};
        return b;
    }

    public static byte[] long2Bytes(long a) {
        byte[] b = new byte[]{(byte)(a >> 56 & 0xFFL), (byte)(a >> 48 & 0xFFL), (byte)(a >> 40 & 0xFFL), (byte)(a >> 32 & 0xFFL), (byte)(a >> 24 & 0xFFL), (byte)(a >> 16 & 0xFFL), (byte)(a >> 8 & 0xFFL), (byte)(a & 0xFFL)};
        return b;
    }

    public static int readUnsignedByte(byte b) {
        return b >= 0 ? b : b + 256;
    }

    public static int readUnsignedShort(byte[] b, int offset) {
        int ch1 = IOStreamConvertor.readUnsignedByte(b[0 + offset]);
        int ch2 = IOStreamConvertor.readUnsignedByte(b[1 + offset]);
        return (ch1 << 8) + (ch2 << 0);
    }

    public static byte[] unsignedShort2Bytes(int a) {
        byte[] b = new byte[]{(byte)(a >> 8 & 0xFF), (byte)(a & 0xFF)};
        return b;
    }

    public static int readInt(byte[] b, int offset) {
        int ch1 = IOStreamConvertor.readUnsignedByte(b[0 + offset]);
        int ch2 = IOStreamConvertor.readUnsignedByte(b[1 + offset]);
        int ch3 = IOStreamConvertor.readUnsignedByte(b[2 + offset]);
        int ch4 = IOStreamConvertor.readUnsignedByte(b[3 + offset]);
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public static long readLong(byte[] b, int offset) {
        long ch1 = IOStreamConvertor.readUnsignedByte(b[0 + offset]);
        long ch2 = IOStreamConvertor.readUnsignedByte(b[1 + offset]);
        long ch3 = IOStreamConvertor.readUnsignedByte(b[2 + offset]);
        long ch4 = IOStreamConvertor.readUnsignedByte(b[3 + offset]);
        long ch5 = IOStreamConvertor.readUnsignedByte(b[4 + offset]);
        long ch6 = IOStreamConvertor.readUnsignedByte(b[5 + offset]);
        long ch7 = IOStreamConvertor.readUnsignedByte(b[6 + offset]);
        long ch8 = IOStreamConvertor.readUnsignedByte(b[7 + offset]);
        return (ch1 << 56) + (ch2 << 48) + (ch3 << 40) + (ch4 << 32) + (ch5 << 24) + (ch6 << 16) + (ch7 << 8) + (ch8 << 0);
    }

    public static int readPositiveShort(byte[] b, int offset) {
        int ch1 = IOStreamConvertor.readChar(b[0 + offset]);
        int ch2 = IOStreamConvertor.readChar(b[1 + offset]);
        return (ch1 << 4) + (ch2 << 0);
    }

    public static int readPositiveInt(byte[] b, int offset) {
        int ch1 = IOStreamConvertor.readChar(b[0 + offset]);
        int ch2 = IOStreamConvertor.readChar(b[1 + offset]);
        int ch3 = IOStreamConvertor.readChar(b[2 + offset]);
        int ch4 = IOStreamConvertor.readChar(b[3 + offset]);
        return (ch1 << 12) + (ch2 << 8) + (ch3 << 4) + (ch4 << 0);
    }

    public static int readPositiveLong(byte[] b, int offset) {
        int ch1 = IOStreamConvertor.readChar(b[0 + offset]);
        int ch2 = IOStreamConvertor.readChar(b[1 + offset]);
        int ch3 = IOStreamConvertor.readChar(b[2 + offset]);
        int ch4 = IOStreamConvertor.readChar(b[3 + offset]);
        int ch5 = IOStreamConvertor.readChar(b[4 + offset]);
        int ch6 = IOStreamConvertor.readChar(b[5 + offset]);
        int ch7 = IOStreamConvertor.readChar(b[6 + offset]);
        int ch8 = IOStreamConvertor.readChar(b[7 + offset]);
        return (ch1 << 28) + (ch2 << 24) + (ch3 << 20) + (ch4 << 16) + (ch5 << 12) + (ch6 << 8) + (ch7 << 4) + (ch8 << 0);
    }

    private static int readChar(byte b) {
        switch (b) {
            case 65: 
            case 97: {
                return 10;
            }
            case 66: 
            case 98: {
                return 11;
            }
            case 67: 
            case 99: {
                return 12;
            }
            case 68: 
            case 100: {
                return 13;
            }
            case 69: 
            case 101: {
                return 14;
            }
            case 70: 
            case 102: {
                return 15;
            }
        }
        return b - 48;
    }

    public static long readUnsignedInt(byte[] b, int offset) {
        int ch1 = IOStreamConvertor.readInt(b, offset);
        long a = 0x100000000L;
        return ch1 >= 0 ? (long)ch1 : (long)ch1 + a;
    }

    public static String getStringFromByteArray(byte[] data) {
        StringBuilder sb = new StringBuilder();
        sb.append(LINE_SEPARATOR);
        int counter = 0;
        for (int i = 0; i < data.length; ++i) {
            int temp = data[i] >= 0 ? data[i] : data[i] + 256;
            String t = Integer.toString(temp, 16);
            if (t.length() < 2) {
                t = "0" + t;
            }
            sb.append(t).append(DATA_SEPARATOR);
            if ((counter + 1) % 16 == 0) {
                sb.append(LINE_SEPARATOR);
                counter = 0;
                continue;
            }
            ++counter;
        }
        while (counter < 16) {
            sb.append(BLANK_DATA).append(DATA_SEPARATOR);
            ++counter;
        }
        return sb.toString();
    }

    public static void replaceSpecialStr(byte[] b) {
        for (int i = 0; i < b.length; ++i) {
            if (b[i] != 13 && b[i] != 10) continue;
            b[i] = 46;
        }
    }

    public static String replaceSpecialStr(String str) {
        StringBuffer strBuff = new StringBuffer();
        if (null == str) {
            return "";
        }
        int size = str.length();
        for (int i = 0; i < size && '\u0000' != str.charAt(i); ++i) {
            strBuff.append(str.charAt(i));
        }
        return strBuff.toString();
    }

    public static long readLong(long i) {
        long a = 0x100000000L;
        return i >= 0L ? i : i + a;
    }

    public static String hexChangToString(byte[] byteArr) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < byteArr.length; ++i) {
            int temp = byteArr[i] >= 0 ? byteArr[i] : byteArr[i] + 256;
            String t = Integer.toString(temp, 16);
            if (t.length() < 2) {
                t = "0" + t;
            }
            sb.append(t);
        }
        return sb.toString().toUpperCase(Locale.getDefault());
    }

    public static byte[] getByteArrayFromString(String str) {
        if ((str = str.replaceAll(DATA_SEPARATOR, "")).length() % 2 != 0) {
            str = str + "0";
        }
        byte[] strByte = str.getBytes();
        byte[] unibyte = new byte[1];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (int i = 0; i < strByte.length; i += 2) {
            strByte[i] = IOStreamConvertor.hexChangeToTen(strByte[i]);
            strByte[i + 1] = IOStreamConvertor.hexChangeToTen(strByte[i + 1]);
            unibyte[0] = (byte)(strByte[i] << 4 | strByte[i + 1]);
            try {
                bos.write(unibyte);
                continue;
            }
            catch (Exception e) {
                LoggerFactory.getLogger(IOStreamConvertor.class).error("getByteArrayFromString() Error!", (Throwable)e);
            }
        }
        return bos.toByteArray();
    }

    public static byte hexChangeToTen(byte word) {
        switch (word) {
            case 48: {
                word = 0;
                break;
            }
            case 49: {
                word = 1;
                break;
            }
            case 50: {
                word = (byte)2;
                break;
            }
            case 51: {
                word = (byte)3;
                break;
            }
            case 52: {
                word = (byte)4;
                break;
            }
            case 53: {
                word = (byte)5;
                break;
            }
            case 54: {
                word = (byte)6;
                break;
            }
            case 55: {
                word = (byte)7;
                break;
            }
            case 56: {
                word = (byte)8;
                break;
            }
            case 57: {
                word = (byte)9;
                break;
            }
            case 65: 
            case 97: {
                word = (byte)10;
                break;
            }
            case 66: 
            case 98: {
                word = (byte)11;
                break;
            }
            case 67: 
            case 99: {
                word = (byte)12;
                break;
            }
            case 68: 
            case 100: {
                word = (byte)13;
                break;
            }
            case 69: 
            case 101: {
                word = (byte)14;
                break;
            }
            case 70: 
            case 102: {
                word = (byte)15;
                break;
            }
            default: {
                word = (byte)48;
            }
        }
        return word;
    }
}

