/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.jdbc;

import com.mchange.v2.c3p0.DataSources;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class C3P0Configuration {
    private static final Logger log = LoggerFactory.getLogger(C3P0Configuration.class);
    private static final String PROP_JDBC_DRIVER = "JDBC.Driver";
    private static final String PROP_JDBC_URL = "JDBC.ConnectionURL";
    private static final String PROP_JDBC_USERNAME = "JDBC.Username";
    private static final String PROP_JDBC_PASSWORD = "JDBC.Password";
    private static final String PROP_JDBC_DEFAULT_AUTOCOMMIT = "JDBC.DefaultAutoCommit";
    private static final String C3P0_PREFIX = "c3p0.";
    private DataSource dataSource;
    private boolean autocommit;

    public C3P0Configuration(Map properties) {
        try {
            this.configure(properties);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error initializing C3P0DataSourceFactory.  Cause: " + e, e);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    private void configure(Map properties) throws IllegalArgumentException, ClassNotFoundException, SQLException {
        String jdbcDriverClass = (String)properties.get(PROP_JDBC_DRIVER);
        String jdbcUrl = (String)properties.get(PROP_JDBC_URL);
        String username = (String)properties.get(PROP_JDBC_USERNAME);
        String password = (String)properties.get(PROP_JDBC_PASSWORD);
        log.info("C3P0 using driver: " + jdbcDriverClass + " at URL: " + jdbcUrl);
        String autoCommitStr = (String)properties.get(PROP_JDBC_DEFAULT_AUTOCOMMIT);
        this.autocommit = null == autoCommitStr ? false : "true".equals(autoCommitStr);
        log.info("autocommit mode: " + this.autocommit);
        if (null == jdbcDriverClass) {
            log.warn("No JDBC Driver class was specified by property JDBC.Driver");
            throw new IllegalArgumentException("No JDBC Driver class was specified by property JDBC.Driver");
        }
        Class.forName(jdbcDriverClass);
        DataSource unpooled = DataSources.unpooledDataSource((String)jdbcUrl, (String)username, (String)password);
        Properties c3prop = new Properties();
        for (Map.Entry entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(C3P0_PREFIX)) continue;
            c3prop.put(key, entry.getValue());
        }
        this.dataSource = DataSources.pooledDataSource((DataSource)unpooled, (Properties)c3prop);
    }

    public void close() {
        try {
            DataSources.destroy((DataSource)this.dataSource);
        }
        catch (SQLException sqle) {
            log.warn("could not destroy C3P0 connection pool", (Throwable)sqle);
        }
    }
}

