/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.ibatis.impl;

import com.huawei.commextend.frameutil.DBInfo;
import com.huawei.commextend.frameutil.DBInfoQuery;
import com.huawei.uflight.ibatis.IBatisService;
import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapClientBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IBatisServiceImpl
implements IBatisService {
    private static final String DEFAULT_CONFIG_FILE = "conf/SqlMapConfig.xml";
    private static final String JDBC_DRIVER_KEY = "JDBC.Driver";
    private static final String JDBC_URL_KEY = "JDBC.ConnectionURL";
    private static final String JDBC_USERNAME_KEY = "JDBC.Username";
    private static final String JDBC_PASSWORD_KEY = "JDBC.Password";
    private SqlMapClient defaultClient;
    private Logger logger = LoggerFactory.getLogger(IBatisServiceImpl.class);

    @Override
    public synchronized SqlMapClient getDefaultSqlMapClient() {
        if (null == this.defaultClient) {
            File file = new File(DEFAULT_CONFIG_FILE);
            try {
                this.defaultClient = this.buildSqlMapClient(file.toURI().toURL());
            }
            catch (MalformedURLException ex) {
                this.logger.error("build SqlMapClient failed, file = conf/SqlMapConfig.xml", (Throwable)ex);
            }
        }
        return this.defaultClient;
    }

    @Override
    public synchronized SqlMapClient buildSqlMapClient(URL url) {
        return this.buildSqlMapClient(url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SqlMapClient buildSqlMapClient(URL url, String dbName) {
        InputStream in = null;
        SqlMapClient client = null;
        try {
            in = url.openStream();
            Properties props = null;
            if (null != dbName) {
                props = this.getDataSourcePro(dbName);
            }
            client = SqlMapClientBuilder.buildSqlMapClient((InputStream)in, props);
        }
        catch (FileNotFoundException ex) {
            this.logger.error("file not found, file = " + url, (Throwable)ex);
        }
        catch (Exception ex) {
            this.logger.error("build SqlMapClient faild, file = " + url, (Throwable)ex);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    this.logger.error("close file failed, file = " + url, (Throwable)ex);
                }
            }
        }
        return client;
    }

    private Properties getDataSourcePro(String dbName) {
        Properties databasePro = new Properties();
        try {
            DBInfo dbInfo = DBInfoQuery.getDBConfInfo((String)dbName);
            if (dbName.equals(dbInfo.getDbName())) {
                databasePro.put(JDBC_DRIVER_KEY, DBInfoQuery.getDBDriver((int)dbInfo.getDbType()));
                databasePro.put(JDBC_URL_KEY, DBInfoQuery.getDBConnURL((DBInfo)dbInfo));
                databasePro.put(JDBC_USERNAME_KEY, dbInfo.getDbUserName());
                databasePro.put(JDBC_PASSWORD_KEY, dbInfo.getDbPasswd());
            }
        }
        catch (Exception e) {
            this.logger.error("getDataSourcePro(" + dbName + ") error.", (Throwable)e);
        }
        return databasePro;
    }
}

