/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.hibernate.template.transaction;

import com.huawei.uflight.hibernate.ISessionFactoryConfigurator;
import java.lang.reflect.Method;
import java.net.URL;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.hibernate.SessionFactory;
import org.hibernate.engine.SessionFactoryImplementor;

public class TransactionSessionFactoryConfigurator
implements ISessionFactoryConfigurator {
    private ISessionFactoryConfigurator realConfigurator;
    private SessionFactory sf;
    private TransactionSessionFactoryProxy proxy;

    public TransactionSessionFactoryConfigurator(ISessionFactoryConfigurator realConfigurator) {
        this.realConfigurator = realConfigurator;
    }

    @Override
    public void closeSessionFactory() {
        this.realConfigurator.closeSessionFactory();
        this.sf.close();
    }

    @Override
    public SessionFactory getSessionFactory() {
        return this.sf;
    }

    @Override
    public URL getURL() {
        return this.realConfigurator.getURL();
    }

    @Override
    public void initSessionFactory() {
        this.realConfigurator.initSessionFactory();
        SessionFactory realFactory = this.realConfigurator.getSessionFactory();
        if (realFactory == null) {
            return;
        }
        this.proxy = new TransactionSessionFactoryProxy(realFactory);
        Enhancer e = new Enhancer();
        e.setInterfaces(new Class[]{SessionFactory.class, SessionFactoryImplementor.class});
        e.setCallback((Callback)this.proxy);
        this.sf = (SessionFactory)e.create();
    }

    void setSessionFactoryMethodInterceptor(ISessionFactoryMethodInterceptor interceptor) {
        this.proxy.setSessionFactoryMethodInterceptor(interceptor);
    }

    static interface ISessionFactoryMethodInterceptor {
        public Object intercept(SessionFactory var1, Object var2, Method var3, Object[] var4, MethodProxy var5) throws Throwable;
    }

    private class TransactionSessionFactoryProxy
    implements MethodInterceptor {
        private SessionFactory realSessionFactory;
        private ISessionFactoryMethodInterceptor interceptor;

        public TransactionSessionFactoryProxy(SessionFactory realSessionFactory) {
            this.realSessionFactory = realSessionFactory;
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            if (null == this.interceptor) {
                return method.invoke((Object)this.realSessionFactory, args);
            }
            return this.interceptor.intercept(this.realSessionFactory, obj, method, args, proxy);
        }

        void setSessionFactoryMethodInterceptor(ISessionFactoryMethodInterceptor interceptor) {
            this.interceptor = interceptor;
        }
    }
}

