/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.hibernate.template.transaction;

import com.huawei.uflight.transaction.ITransactionContext;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.hibernate.Session;
import org.hibernate.StatelessSession;

public class HibernateTransactionContext
implements ITransactionContext {
    private Session session;
    private StatelessSession statelessSession;
    private Session realSession;
    private StatelessSession realStatelessSession;
    private TransactionAdaptor transaction = new TransactionAdaptor();
    private boolean isCompleted = true;

    public Transaction getTransaction() {
        return this.transaction;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public boolean isRollbackOnly() {
        return this.transaction.isRollbackOnly();
    }

    Session getSession() {
        return this.session;
    }

    void setSession(Session session) {
        this.session = session;
    }

    StatelessSession getStatelessSession() {
        return this.statelessSession;
    }

    void setStatelessSession(StatelessSession statelessSession) {
        this.statelessSession = statelessSession;
    }

    void setRealSession(Session realSession) {
        this.realSession = realSession;
    }

    void setRealStatelessSession(StatelessSession realStatelessSession) {
        this.realStatelessSession = realStatelessSession;
    }

    void setCompleted(boolean isCompleted) {
        this.isCompleted = isCompleted;
    }

    private class TransactionAdaptor
    implements Transaction {
        private boolean isRollbackOnly;

        private TransactionAdaptor() {
        }

        public boolean isRollbackOnly() {
            return this.isRollbackOnly;
        }

        public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
            if (null != HibernateTransactionContext.this.realSession) {
                HibernateTransactionContext.this.realSession.getTransaction().commit();
                HibernateTransactionContext.this.realSession.close();
            }
            if (null != HibernateTransactionContext.this.realStatelessSession) {
                HibernateTransactionContext.this.realStatelessSession.getTransaction().commit();
                HibernateTransactionContext.this.realStatelessSession.close();
            }
            HibernateTransactionContext.this.setCompleted(true);
        }

        public boolean delistResource(XAResource xaresource, int i) throws IllegalStateException, SystemException {
            return false;
        }

        public boolean enlistResource(XAResource xaresource) throws RollbackException, IllegalStateException, SystemException {
            return false;
        }

        public int getStatus() throws SystemException {
            return 0;
        }

        public void registerSynchronization(Synchronization synchronization) throws RollbackException, IllegalStateException, SystemException {
        }

        public void rollback() throws IllegalStateException, SystemException {
            if (null != HibernateTransactionContext.this.realSession) {
                HibernateTransactionContext.this.realSession.getTransaction().rollback();
                HibernateTransactionContext.this.realSession.close();
            }
            if (null != HibernateTransactionContext.this.realStatelessSession) {
                HibernateTransactionContext.this.realStatelessSession.getTransaction().rollback();
                HibernateTransactionContext.this.realStatelessSession.close();
            }
            HibernateTransactionContext.this.setCompleted(true);
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            this.isRollbackOnly = true;
        }
    }
}

