/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.hibernate.template.transaction;

import com.huawei.uflight.hibernate.template.IHibernateTemplate;
import com.huawei.uflight.hibernate.template.impl.HibernateTemplateImpl;
import com.huawei.uflight.hibernate.template.transaction.HibernateTransactionContext;
import com.huawei.uflight.hibernate.template.transaction.TransactionSessionFactoryConfigurator;
import com.huawei.uflight.transaction.ITransactionContext;
import com.huawei.uflight.transaction.ITransactionManager;
import com.huawei.uflight.transaction.TransactionException;
import java.lang.reflect.Method;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.engine.SessionImplementor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateThreadLocalTransactionManager
implements ITransactionManager {
    private static Logger logger = LoggerFactory.getLogger(HibernateThreadLocalTransactionManager.class);
    private IHibernateTemplate template;
    private TransactionSessionFactoryConfigurator configurator;
    private ThreadLocal<HibernateTransactionContext> context = new ThreadLocal();

    public HibernateThreadLocalTransactionManager(IHibernateTemplate template) throws TransactionException {
        this.template = template;
        if (!(template instanceof HibernateTemplateImpl)) {
            throw new TransactionException("template is not a HibernateTemplateImpl");
        }
        HibernateTemplateImpl templateImpl = (HibernateTemplateImpl)template;
        if (!(templateImpl.getConfigurator() instanceof TransactionSessionFactoryConfigurator)) {
            throw new TransactionException("this template is not a Transaction supported template, please check your config.");
        }
        this.configurator = (TransactionSessionFactoryConfigurator)templateImpl.getConfigurator();
        this.configurator.setSessionFactoryMethodInterceptor(new TransactionSessionFactoryMethodInterceptor());
    }

    public ITransactionContext begin() throws TransactionException {
        HibernateTransactionContext ctx = new HibernateTransactionContext();
        this.context.set(ctx);
        return ctx;
    }

    public void commit(ITransactionContext ctx) throws TransactionException {
        try {
            ctx.getTransaction().commit();
        }
        catch (Exception ex) {
            throw new TransactionException((Throwable)ex);
        }
    }

    public ITransactionContext getCurrentThreadTransactionCtx() {
        return this.context.get();
    }

    public void rollback(ITransactionContext ctx) throws TransactionException {
        try {
            ctx.getTransaction().rollback();
        }
        catch (Exception ex) {
            throw new TransactionException((Throwable)ex);
        }
    }

    private <T> T proxy(T real, MethodInterceptor interceptor) {
        Enhancer e = new Enhancer();
        e.setInterfaces(new Class[]{Transaction.class, real.getClass()});
        e.setCallback((Callback)interceptor);
        return (T)e.create();
    }

    private Session proxySession(Session session) {
        return this.proxy(session, new SessionProxy(session));
    }

    private StatelessSession proxyStatelessSession(StatelessSession statelessSession) {
        return this.proxy(statelessSession, new SessionProxy(statelessSession));
    }

    private class HibernateTransactionProxy
    implements MethodInterceptor {
        private Transaction realTransaction;

        private HibernateTransactionProxy(Transaction realTransaction) {
            this.realTransaction = realTransaction;
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy methodproxy) throws Throwable {
            if ("begin".equals(method.getName())) {
                HibernateTransactionContext ctx = (HibernateTransactionContext)HibernateThreadLocalTransactionManager.this.context.get();
                if (ctx.isCompleted()) {
                    ctx.setCompleted(false);
                    return method.invoke((Object)this.realTransaction, args);
                }
                return null;
            }
            if ("commit".equals(method.getName())) {
                return null;
            }
            if ("rollback".equals(method.getName())) {
                return null;
            }
            return method.invoke((Object)this.realTransaction, args);
        }
    }

    private class SessionProxy
    implements MethodInterceptor {
        private SessionImplementor realSession;

        private SessionProxy(Session session) {
            this.realSession = (SessionImplementor)session;
        }

        private SessionProxy(StatelessSession session) {
            this.realSession = (SessionImplementor)session;
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            if ("beginTransaction".equals(method.getName())) {
                return methodProxy.invoke(obj, args);
            }
            if ("getTransaction".equals(method.getName())) {
                return this.proxyTransaction((Transaction)method.invoke((Object)this.realSession, args));
            }
            if ("close".equals(method.getName())) {
                return null;
            }
            return method.invoke((Object)this.realSession, args);
        }

        private Transaction proxyTransaction(Transaction realTransaction) {
            return (Transaction)HibernateThreadLocalTransactionManager.this.proxy(realTransaction, new HibernateTransactionProxy(realTransaction));
        }
    }

    private class TransactionSessionFactoryMethodInterceptor
    implements TransactionSessionFactoryConfigurator.ISessionFactoryMethodInterceptor {
        private TransactionSessionFactoryMethodInterceptor() {
        }

        @Override
        public Object intercept(SessionFactory realSessionFactory, Object obj, Method method, Object[] aobj, MethodProxy methodproxy) throws Throwable {
            if (null == HibernateThreadLocalTransactionManager.this.context.get()) {
                return method.invoke((Object)realSessionFactory, aobj);
            }
            HibernateTransactionContext ctx = (HibernateTransactionContext)HibernateThreadLocalTransactionManager.this.context.get();
            if ("openSession".equals(method.getName())) {
                if (null != ctx.getSession()) {
                    return ctx.getSession();
                }
                Session session = (Session)method.invoke((Object)realSessionFactory, aobj);
                Session proxySession = HibernateThreadLocalTransactionManager.this.proxySession(session);
                ctx.setSession(proxySession);
                ctx.setRealSession(session);
                return proxySession;
            }
            if ("openStatelessSession".equals(method.getName())) {
                if (null != ctx.getStatelessSession()) {
                    return ctx.getStatelessSession();
                }
                StatelessSession session = (StatelessSession)method.invoke((Object)realSessionFactory, aobj);
                StatelessSession proxySession = HibernateThreadLocalTransactionManager.this.proxyStatelessSession(session);
                ctx.setStatelessSession(proxySession);
                ctx.setRealStatelessSession(session);
                return proxySession;
            }
            if ("getCurrentSession".equals(method.getName())) {
                Session session = (Session)method.invoke((Object)realSessionFactory, aobj);
                return HibernateThreadLocalTransactionManager.this.proxySession(session);
            }
            return method.invoke((Object)realSessionFactory, aobj);
        }
    }
}

