/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.hibernate.template.impl;

import com.huawei.uflight.hibernate.ISessionFactoryConfigurator;
import com.huawei.uflight.hibernate.template.CascadeOperationFactory;
import com.huawei.uflight.hibernate.template.HibernateTemplateException;
import com.huawei.uflight.hibernate.template.ICascadeDelete;
import com.huawei.uflight.hibernate.template.ICascadeInsert;
import com.huawei.uflight.hibernate.template.ICascadeUpdate;
import com.huawei.uflight.hibernate.template.IHibernateTemplate;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.classic.Session;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.proxy.HibernateProxyHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateTemplateImpl
implements IHibernateTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(HibernateTemplateImpl.class);
    private ISessionFactoryConfigurator configurator;
    private List<IStateChangeListener> listeners = new ArrayList<IStateChangeListener>();

    public HibernateTemplateImpl(ISessionFactoryConfigurator configurator) {
        this.configurator = configurator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void batchDelete(Collection<T> objects) throws HibernateTemplateException {
        if (objects == null || objects.isEmpty()) {
            LOGGER.debug("delete collection is empty.");
            return;
        }
        SessionFactory factory = this.configurator.getSessionFactory();
        StatelessSession session = factory.openStatelessSession();
        session.beginTransaction();
        Class persistClass = HibernateProxyHelper.getClassWithoutInitializingProxy(objects.iterator().next());
        ICascadeDelete deleter = CascadeOperationFactory.getInstance().find(persistClass, ICascadeDelete.class);
        boolean sucess = false;
        try {
            deleter.delete(objects, (SessionImplementor)session, (SessionFactoryImplementor)factory);
            session.getTransaction().commit();
            sucess = true;
        }
        finally {
            if (!sucess) {
                session.getTransaction().rollback();
            }
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void batchInsert(Collection<T> objects) throws HibernateTemplateException {
        if (objects == null || objects.isEmpty()) {
            LOGGER.debug("insert collection is empty.");
            return;
        }
        SessionFactory factory = this.configurator.getSessionFactory();
        StatelessSession session = factory.openStatelessSession();
        session.beginTransaction();
        Class<?> persistClass = objects.iterator().next().getClass();
        ICascadeInsert inserter = CascadeOperationFactory.getInstance().find(persistClass, ICascadeInsert.class);
        boolean sucess = false;
        try {
            inserter.insert(objects, (SessionImplementor)session, (SessionFactoryImplementor)factory);
            session.getTransaction().commit();
            sucess = true;
        }
        finally {
            if (!sucess) {
                session.getTransaction().rollback();
            }
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void batchUpdate(Collection<T> objects) throws HibernateTemplateException {
        if (objects == null || objects.isEmpty()) {
            LOGGER.debug("update collection is empty.");
            return;
        }
        SessionFactory factory = this.configurator.getSessionFactory();
        StatelessSession session = factory.openStatelessSession();
        session.beginTransaction();
        Class<?> persistClass = objects.iterator().next().getClass();
        ICascadeUpdate updater = CascadeOperationFactory.getInstance().find(persistClass, ICascadeUpdate.class);
        boolean sucess = false;
        try {
            updater.update(objects, (SessionImplementor)session, (SessionFactoryImplementor)factory);
            session.getTransaction().commit();
            sucess = true;
        }
        finally {
            if (!sucess) {
                session.getTransaction().rollback();
            }
            session.close();
        }
    }

    @Override
    public <T> void delete(T object) throws HibernateTemplateException {
        if (object == null) {
            LOGGER.debug("delete object is null.");
            return;
        }
        ArrayList<T> deletes = new ArrayList<T>(1);
        deletes.add(object);
        this.batchDelete(deletes);
    }

    @Override
    public <T> void insert(T object) throws HibernateTemplateException {
        if (object == null) {
            LOGGER.debug("insert object is null.");
            return;
        }
        ArrayList<T> inserts = new ArrayList<T>(1);
        inserts.add(object);
        this.batchInsert(inserts);
    }

    @Override
    public <T> void update(T object) throws HibernateTemplateException {
        if (object == null) {
            LOGGER.debug("update object is null.");
            return;
        }
        ArrayList<T> updates = new ArrayList<T>(1);
        updates.add(object);
        this.batchUpdate(updates);
    }

    @Override
    public void deleteByHql(String hql, Map<String, Object> filter) throws HibernateTemplateException {
        if (hql == null) {
            LOGGER.debug("delete hql is null.");
            return;
        }
        this.executeUpdate(hql, filter);
    }

    @Override
    public void updateByHql(String hql, Map<String, Object> filter) throws HibernateTemplateException {
        if (hql == null) {
            LOGGER.debug("update hql is null.");
            return;
        }
        this.executeUpdate(hql, filter);
    }

    private void executeUpdate(String hql, Map<String, Object> filter) throws HibernateTemplateException {
        SessionFactory factory = this.configurator.getSessionFactory();
        Session session = factory.getCurrentSession();
        session.beginTransaction();
        boolean sucess = false;
        try {
            Query query = session.createQuery(hql);
            if (filter != null) {
                query.setProperties(filter);
            }
            query.executeUpdate();
            session.getTransaction().commit();
            sucess = true;
        }
        catch (HibernateException e) {
            throw new HibernateTemplateException("execute by hql:" + hql + " parameters:" + (filter == null ? "" : filter.toString()), e);
        }
        finally {
            if (!sucess) {
                session.getTransaction().rollback();
            }
            if (session.isOpen()) {
                session.close();
            }
        }
    }

    @Override
    public long getCount(String hql, Map<String, Object> filter) throws HibernateTemplateException {
        if (hql == null) {
            LOGGER.debug("hql is null.");
            return 0L;
        }
        SessionFactory factory = this.configurator.getSessionFactory();
        StatelessSession session = factory.openStatelessSession();
        session.beginTransaction();
        boolean sucess = false;
        long count = 0L;
        try {
            Query query = session.createQuery(hql);
            if (filter != null) {
                query.setProperties(filter);
            }
            count = (Long)query.list().iterator().next();
            session.getTransaction().commit();
            sucess = true;
        }
        catch (HibernateException e) {
            throw new HibernateTemplateException("getCount by hql:" + hql + " parameters:" + (filter == null ? "" : filter.toString()), e);
        }
        finally {
            if (!sucess) {
                session.getTransaction().rollback();
                session.close();
            }
        }
        return count;
    }

    @Override
    public <T> List<T> paginateQueryByHql(String hql, Map<String, Object> filter, int page, int max) throws HibernateTemplateException {
        SessionFactory factory = this.configurator.getSessionFactory();
        Session session = factory.getCurrentSession();
        session.beginTransaction();
        boolean sucess = false;
        List list = new ArrayList();
        try {
            Query query = session.createQuery(hql);
            if (filter != null) {
                query.setProperties(filter);
            }
            query.setFirstResult((page < 2 ? 0 : page - 1) * max);
            query.setMaxResults(max);
            list = query.setCacheable(true).list();
            session.getTransaction().commit();
            sucess = true;
        }
        catch (HibernateException e) {
            throw new HibernateTemplateException("paginateQueryByHql by hql:" + hql + " parameters:" + (filter == null ? "" : filter.toString()), e);
        }
        finally {
            if (!sucess) {
                session.getTransaction().rollback();
            }
            if (session.isOpen()) {
                session.close();
            }
        }
        return list;
    }

    @Override
    public <T> List<T> queryListByHql(String hql, Map<String, Object> filter) throws HibernateTemplateException {
        SessionFactory factory = this.configurator.getSessionFactory();
        Session session = factory.getCurrentSession();
        session.beginTransaction();
        boolean sucess = false;
        List list = new ArrayList();
        try {
            Query query = session.createQuery(hql);
            if (filter != null) {
                query.setProperties(filter);
            }
            list = query.setCacheable(true).list();
            session.getTransaction().commit();
            sucess = true;
        }
        catch (HibernateException e) {
            throw new HibernateTemplateException("queryListByHql by hql:" + hql + " parameters:" + (filter == null ? "" : filter.toString()), e);
        }
        finally {
            if (!sucess) {
                session.getTransaction().rollback();
            }
            if (session.isOpen()) {
                session.close();
            }
        }
        return list;
    }

    @Override
    public <T> T queryByHql(String hql, Map<String, Object> filter) throws HibernateTemplateException {
        SessionFactory factory = this.configurator.getSessionFactory();
        Session session = factory.getCurrentSession();
        session.beginTransaction();
        boolean sucess = false;
        Object result = null;
        try {
            Query query = session.createQuery(hql);
            if (filter != null) {
                query.setProperties(filter);
            }
            result = query.uniqueResult();
            session.getTransaction().commit();
            sucess = true;
        }
        catch (HibernateException e) {
            throw new HibernateTemplateException("queryByHql by hql:" + hql + " parameters:" + (filter == null ? "" : filter.toString()), e);
        }
        finally {
            if (!sucess) {
                session.getTransaction().rollback();
            }
            if (session.isOpen()) {
                session.close();
            }
        }
        return (T)result;
    }

    @Override
    public void release() {
        this.configurator.closeSessionFactory();
        for (IStateChangeListener listener : this.listeners) {
            listener.release(this.configurator.getURL());
        }
    }

    public void addStateChangeListener(IStateChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeStateChangeListener(IStateChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public SessionFactory getSessionFactory() {
        return this.configurator.getSessionFactory();
    }

    public ISessionFactoryConfigurator getConfigurator() {
        return this.configurator;
    }

    @Override
    public Criteria createCriteria(Class<?> clazz) {
        SessionFactory factory = this.getConfigurator().getSessionFactory();
        Session session = factory.getCurrentSession();
        session.beginTransaction();
        Criteria criteria = session.createCriteria(clazz);
        return criteria;
    }

    public static interface IStateChangeListener {
        public void release(URL var1);
    }
}

