/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.hibernate.template.impl;

import com.huawei.uflight.hibernate.template.IDeleteForeignKeyHandler;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.sql.Delete;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForeignKeyImpl
implements IDeleteForeignKeyHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ForeignKeyImpl.class);

    @Override
    public void where(AbstractEntityPersister persister, SessionFactoryImplementor factory, Delete delete) {
        if (!this.checkParameter(persister, factory, delete)) {
            return;
        }
        String[] columns = persister.getIdentifierColumnNames();
        delete.setPrimaryKeyColumnNames(columns);
    }

    public void dehydrate(Object object, AbstractEntityPersister persister, SessionFactoryImplementor factory, SessionImplementor session, PreparedStatement ps, int index) throws HibernateException, SQLException {
        if (!this.checkParameter(persister, factory, ps)) {
            return;
        }
        if (object == null) {
            return;
        }
        Type type = persister.getIdentifierType();
        type.nullSafeSet(ps, object, index, session);
    }

    private boolean checkParameter(AbstractEntityPersister persister, SessionFactoryImplementor factory, Delete delete) {
        if (!this.checkParameter(persister, factory)) {
            return false;
        }
        if (delete == null) {
            LOGGER.debug("IllegalArgument: null Delete.");
            return false;
        }
        return true;
    }

    private boolean checkParameter(AbstractEntityPersister persister, SessionFactoryImplementor factory, PreparedStatement ps) {
        if (!this.checkParameter(persister, factory)) {
            return false;
        }
        if (ps == null) {
            LOGGER.debug("IllegalArgument: null PreparedStatement.");
            return false;
        }
        return true;
    }

    private boolean checkParameter(AbstractEntityPersister persister, SessionFactoryImplementor factory) {
        if (persister == null) {
            LOGGER.debug("IllegalArgument: null AbstractEntityPersister.");
            return false;
        }
        if (factory == null) {
            LOGGER.debug("IllegalArgument: null SessionFactory.");
            return false;
        }
        return true;
    }
}

