/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.hibernate.template.impl;

import com.huawei.uflight.hibernate.template.IRelationLifeCycle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.hibernate.EntityMode;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.persister.entity.EntityPersister;

public class DefaultRelationLifeCycle
implements IRelationLifeCycle {
    @Override
    public <P, I, U, D> void detect(Collection<P> parents, EntityPersister persister, int propertIndex, Collection<I> inserts, Collection<U> updates, Collection<D> deletes) {
        Collection children = this.getChildren(parents, propertIndex, persister, persister.getFactory());
        updates.addAll(children);
    }

    @Override
    public <P, I, D> void detect(Collection<P> parents, EntityPersister persister, int propertIndex, Collection<Collection<I>> inserts, Collection<Collection<D>> deletes) {
        for (P parent : parents) {
            Collection col = (Collection)persister.getPropertyValue(parent, propertIndex, EntityMode.POJO);
            if (col != null && !col.isEmpty()) {
                inserts.add(col);
            }
            ArrayList<Object> deleted = new ArrayList<Object>();
            deleted.add(null);
            deletes.add(deleted);
        }
    }

    protected <P, C, R> Collection<R> getChildren(Collection<P> parents, int propertIndex, EntityPersister persister, SessionFactoryImplementor factory) {
        LinkedList<Object> rs = new LinkedList<Object>();
        for (P parent : parents) {
            Object child = persister.getPropertyValue(parent, propertIndex, EntityMode.POJO);
            if (child == null) continue;
            if (child instanceof Collection) {
                rs.addAll((Collection)child);
                continue;
            }
            rs.add(child);
        }
        return rs;
    }
}

