/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.hibernate.template.impl;

import com.huawei.uflight.hibernate.template.CascadeOperationFactory;
import com.huawei.uflight.hibernate.template.HibernateTemplateException;
import com.huawei.uflight.hibernate.template.ICascadeDelete;
import com.huawei.uflight.hibernate.template.ICascadeInsert;
import com.huawei.uflight.hibernate.template.ICascadeUpdate;
import com.huawei.uflight.hibernate.template.IRelationLifeCycle;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.commons.collections.CollectionUtils;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.engine.CascadeStyle;
import org.hibernate.engine.CascadingAction;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.jdbc.Expectation;
import org.hibernate.jdbc.Expectations;
import org.hibernate.persister.collection.AbstractCollectionPersister;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.proxy.HibernateProxyHelper;
import org.hibernate.sql.Delete;
import org.hibernate.sql.Insert;
import org.hibernate.sql.Update;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.DiscriminatorType;
import org.hibernate.type.EntityType;
import org.hibernate.type.NullableType;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CascadeUpdateImpl
implements ICascadeUpdate {
    private static final Logger LOGGER = LoggerFactory.getLogger(CascadeUpdateImpl.class);
    private static final CascadingAction UPDATE_CASCADE = CascadingAction.SAVE_UPDATE;

    @Override
    public <T> void update(Collection<T> objects, SessionImplementor session, SessionFactoryImplementor factory) throws HibernateTemplateException {
        if (objects == null || objects.isEmpty()) {
            return;
        }
        Class persistClass = HibernateProxyHelper.getClassWithoutInitializingProxy(objects.iterator().next());
        IRelationLifeCycle lifeCycle = CascadeOperationFactory.getInstance().find(persistClass, IRelationLifeCycle.class);
        this.update(objects, lifeCycle, session, factory);
    }

    @Override
    public <T> void update(Collection<T> objects, IRelationLifeCycle lifeCycle, SessionImplementor session, SessionFactoryImplementor factory) throws HibernateTemplateException {
        if (objects == null || objects.isEmpty()) {
            return;
        }
        try {
            Class persistClass = HibernateProxyHelper.getClassWithoutInitializingProxy(objects.iterator().next());
            AbstractEntityPersister persister = (AbstractEntityPersister)factory.getEntityPersister(persistClass.getName());
            this.executeUpdate(objects, persister, session, factory);
            this.updateChild(objects, lifeCycle, session, factory);
        }
        catch (HibernateException e) {
            throw new HibernateTemplateException("update objects exception:" + objects, e);
        }
        catch (SQLException e) {
            throw new HibernateTemplateException("update objects exception:" + objects, e);
        }
    }

    protected <T> void executeUpdate(Collection<T> objects, AbstractEntityPersister persister, SessionImplementor session, SessionFactoryImplementor factory) throws HibernateException, SQLException {
        if (objects == null || objects.isEmpty()) {
            return;
        }
        ArrayList<DynamicUpdateSql> updateSqls = new ArrayList<DynamicUpdateSql>(objects.size());
        for (T object : objects) {
            DynamicUpdateSql updateSql = this.dynamicUpdateSql(object, persister, factory);
            if (updateSql == null) continue;
            updateSqls.add(updateSql);
        }
        Collections.sort(updateSqls);
        Expectation EXPECTATION = Expectations.NONE;
        for (DynamicUpdateSql dynamicUpdateSql : updateSqls) {
            PreparedStatement ps = session.getBatcher().prepareBatchStatement(dynamicUpdateSql.sql);
            EXPECTATION.prepare(ps);
            int index = 1;
            Iterator tit = dynamicUpdateSql.setTypes.iterator();
            Iterator vit = dynamicUpdateSql.setValues.iterator();
            while (tit.hasNext() && vit.hasNext()) {
                Type type = (Type)tit.next();
                Object value = vit.next();
                type.nullSafeSet(ps, value, index, session);
                index += type.getColumnSpan((Mapping)factory);
            }
            persister.getIdentifierType().nullSafeSet(ps, (Object)dynamicUpdateSql.ids, index, session);
            session.getBatcher().addToBatch(EXPECTATION);
        }
    }

    protected <P, I, U, D> void updateChild(Collection<P> parents, IRelationLifeCycle lifeCycle, SessionImplementor session, SessionFactoryImplementor factory) throws HibernateTemplateException, HibernateException, SQLException {
        if (parents == null || parents.isEmpty()) {
            return;
        }
        Class persistClass = HibernateProxyHelper.getClassWithoutInitializingProxy(parents.iterator().next());
        AbstractEntityPersister persister = (AbstractEntityPersister)factory.getEntityPersister(persistClass.getName());
        String[] propertyNames = persister.getPropertyNames();
        Type[] propertyTypes = persister.getPropertyTypes();
        CascadeStyle[] styles = persister.getPropertyCascadeStyles();
        ArrayList insertedChildren = new ArrayList();
        ArrayList deletedChildren = new ArrayList();
        ArrayList updatedChildren = new ArrayList();
        ArrayList<Collection<I>> insertValueChildren = new ArrayList<Collection<I>>();
        ArrayList<Collection<D>> deleteValueChildren = new ArrayList<Collection<D>>();
        for (int i = 0; i < propertyNames.length; ++i) {
            Type type = propertyTypes[i];
            boolean isValueCollection = false;
            boolean doCascade = false;
            if (type instanceof AssociationType && styles[i].doCascade(UPDATE_CASCADE)) {
                if (type instanceof CollectionType) {
                    if (((CollectionType)type).getElementType(factory) instanceof DiscriminatorType) {
                        isValueCollection = true;
                        lifeCycle.detect(parents, (EntityPersister)persister, i, insertValueChildren, deleteValueChildren);
                    }
                    doCascade = true;
                    lifeCycle.detect(parents, (EntityPersister)persister, i, insertedChildren, updatedChildren, deletedChildren);
                } else if (type instanceof EntityType) {
                    doCascade = true;
                    lifeCycle.detect(parents, (EntityPersister)persister, i, insertedChildren, updatedChildren, deletedChildren);
                }
            }
            if (doCascade) {
                if (isValueCollection) {
                    this.deleteValueCollection(parents, deleteValueChildren, persister, i, session, factory);
                    this.insertValueCollection(parents, insertValueChildren, persister, i, session, factory);
                } else {
                    this.deleteChildren(deletedChildren, session, factory);
                    this.insertChildren(insertedChildren, session, factory);
                    if (!CollectionUtils.isEmpty(updatedChildren)) {
                        AbstractEntityPersister childPersister = (AbstractEntityPersister)factory.getEntityPersister(HibernateProxyHelper.getClassWithoutInitializingProxy(updatedChildren.iterator().next()).getName());
                        this.executeUpdate(updatedChildren, childPersister, session, factory);
                        this.invokeUpdate(updatedChildren, lifeCycle, session, factory);
                    }
                }
            }
            insertedChildren.clear();
            deletedChildren.clear();
            updatedChildren.clear();
            insertValueChildren.clear();
            deleteValueChildren.clear();
        }
    }

    private <T> void invokeUpdate(Collection<T> parents, IRelationLifeCycle lifeCycle, SessionImplementor session, SessionFactoryImplementor factory) throws HibernateTemplateException, HibernateException, SQLException {
        this.updateChild(parents, lifeCycle, session, factory);
    }

    protected <I> void insertChildren(Collection<I> children, SessionImplementor session, SessionFactoryImplementor factory) throws HibernateTemplateException {
        if (children == null || children.isEmpty()) {
            return;
        }
        Class persistClass = HibernateProxyHelper.getClassWithoutInitializingProxy(children.iterator().next());
        ICascadeInsert inserter = CascadeOperationFactory.getInstance().find(persistClass, ICascadeInsert.class);
        inserter.insert(children, session, factory);
    }

    protected <P, I> void insertValueCollection(Collection<P> parents, Collection<Collection<I>> childrenCollection, AbstractEntityPersister persister, int propertyIndex, SessionImplementor session, SessionFactoryImplementor factory) throws HibernateException, SQLException {
        CollectionType type = (CollectionType)persister.getPropertyTypes()[propertyIndex];
        CollectionPersister colPersister = factory.getCollectionPersister(type.getRole());
        Joinable joinable = type.getAssociatedJoinable(factory);
        Insert insert = new Insert(factory.getDialect());
        insert.setTableName(joinable.getTableName());
        insert.addColumns(joinable.getKeyColumnNames());
        insert.addColumns(((AbstractCollectionPersister)colPersister).getElementColumnNames());
        String sql = insert.toStatementString();
        Expectation expectation = Expectations.NONE;
        Iterator<P> pit = parents.iterator();
        Iterator<Collection<I>> cit = childrenCollection.iterator();
        while (pit.hasNext() && cit.hasNext()) {
            P parent = pit.next();
            Collection<I> children = cit.next();
            if (children == null || children.isEmpty()) {
                LOGGER.debug("Object []'s child [] is empty.", new Object[]{parent, persister.getPropertyNames()[propertyIndex]});
                continue;
            }
            for (I child : children) {
                PreparedStatement ps = session.getBatcher().prepareBatchStatement(sql);
                expectation.prepare(ps);
                int index = 1;
                persister.getIdentifierType().nullSafeSet(ps, parent, index, session);
                type.getElementType(factory).nullSafeSet(ps, child, index += joinable.getKeyColumnNames().length, session);
                session.getBatcher().addToBatch(expectation);
            }
        }
    }

    protected <D> void deleteChildren(Collection<D> children, SessionImplementor session, SessionFactoryImplementor factory) throws HibernateTemplateException {
        if (children == null || children.isEmpty()) {
            return;
        }
        Class persistClass = HibernateProxyHelper.getClassWithoutInitializingProxy(children.iterator().next());
        ICascadeDelete deleter = CascadeOperationFactory.getInstance().find(persistClass, ICascadeDelete.class);
        deleter.delete(children, session, factory);
    }

    protected <P, D> void deleteValueCollection(Collection<P> parents, Collection<Collection<D>> childrenCollection, AbstractEntityPersister persister, int propertyIndex, SessionImplementor session, SessionFactoryImplementor factory) throws HibernateException, SQLException {
        CollectionType type = (CollectionType)persister.getPropertyTypes()[propertyIndex];
        AbstractCollectionPersister colPersister = (AbstractCollectionPersister)factory.getCollectionPersister(type.getRole());
        Joinable joinable = type.getAssociatedJoinable(factory);
        Delete delete = new Delete();
        delete.setTableName(joinable.getTableName());
        delete.setPrimaryKeyColumnNames(joinable.getKeyColumnNames());
        String deleteAllChildSql = delete.toStatementString();
        String[] primaryKeys = new String[joinable.getKeyColumnNames().length + colPersister.getElementColumnNames().length];
        int begin = 0;
        System.arraycopy(joinable.getKeyColumnNames(), 0, primaryKeys, begin, joinable.getKeyColumnNames().length);
        System.arraycopy(colPersister.getElementColumnNames(), 0, primaryKeys, begin += joinable.getKeyColumnNames().length, colPersister.getElementColumnNames().length);
        delete.setPrimaryKeyColumnNames(primaryKeys);
        String deleteSpecialChildSql = delete.toStatementString();
        Expectation expectation = Expectations.NONE;
        Iterator<P> pit = parents.iterator();
        Iterator<Collection<D>> cit = childrenCollection.iterator();
        while (pit.hasNext() && cit.hasNext()) {
            P parent = pit.next();
            Collection<D> children = cit.next();
            if (children == null || children.isEmpty()) {
                LOGGER.debug("Object []'s child [] is empty.", new Object[]{parent, persister.getPropertyNames()[propertyIndex]});
                continue;
            }
            for (D child : children) {
                PreparedStatement ps = null;
                int pidIndex = 1;
                int cidIndex = pidIndex + joinable.getKeyColumnNames().length;
                if (child == null) {
                    ps = session.getBatcher().prepareBatchStatement(deleteAllChildSql);
                } else {
                    ps = session.getBatcher().prepareBatchStatement(deleteSpecialChildSql);
                    type.getElementType(factory).nullSafeSet(ps, child, cidIndex, session);
                }
                expectation.prepare(ps);
                persister.getIdentifierType().nullSafeSet(ps, parent, pidIndex, session);
                session.getBatcher().addToBatch(expectation);
            }
        }
    }

    protected <T> DynamicUpdateSql dynamicUpdateSql(T object, AbstractEntityPersister persister, SessionFactoryImplementor factory) {
        String[] propertyNames = persister.getPropertyNames();
        Type[] propertyTypes = persister.getPropertyTypes();
        Object[] propertyValues = persister.getPropertyValues(object, EntityMode.POJO);
        boolean[] propertyUpdateable = persister.getPropertyUpdateability();
        boolean needUpdate = false;
        Update update = new Update(factory.getDialect());
        update.setTableName(persister.getTableName());
        LinkedList<Object> setValues = new LinkedList<Object>();
        LinkedList<Type> setTypes = new LinkedList<Type>();
        for (int i = 0; i < propertyNames.length; ++i) {
            String[] columns = persister.getPropertyColumnNames(i);
            if (columns.length <= 0 || propertyValues[i] == null || propertyTypes[i] instanceof NullableType && !propertyUpdateable[i]) continue;
            update.addColumns(columns);
            setValues.offer(propertyValues[i]);
            setTypes.offer(propertyTypes[i]);
            needUpdate = true;
        }
        if (needUpdate) {
            update.setPrimaryKeyColumnNames(persister.getIdentifierColumnNames());
            DynamicUpdateSql updateSql = new DynamicUpdateSql();
            updateSql.sql = update.toStatementString();
            updateSql.setTypes = setTypes;
            updateSql.setValues = setValues;
            updateSql.ids = persister.getIdentifier(object, EntityMode.POJO);
            return updateSql;
        }
        return null;
    }

    protected boolean[][] getPropertyColumnUpdatablilty(AbstractEntityPersister persister) {
        try {
            Field field = persister.getClass().getField("propertyColumnUpdateable");
            field.setAccessible(true);
            return (boolean[][])field.get(persister);
        }
        catch (Exception e) {
            LOGGER.debug("get AbstractEntityPersister field propertyColumnUpdateable value exception:" + e.getMessage());
            boolean[] propertyUpdateable = persister.getPropertyUpdateability();
            boolean[][] columnUpdateable = new boolean[propertyUpdateable.length][];
            for (int i = 0; i < columnUpdateable.length; ++i) {
                columnUpdateable[i] = new boolean[persister.getPropertyColumnNames(i).length];
                if (propertyUpdateable[i]) {
                    Arrays.fill(columnUpdateable[i], true);
                    continue;
                }
                Arrays.fill(columnUpdateable[i], false);
            }
            return columnUpdateable;
        }
    }

    protected static class DynamicUpdateSql
    implements Comparable<DynamicUpdateSql> {
        public String sql;
        public Queue<Object> setValues;
        public Queue<Type> setTypes;
        public Serializable ids;

        protected DynamicUpdateSql() {
        }

        @Override
        public int compareTo(DynamicUpdateSql o) {
            return this.sql.compareTo(o.sql);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof DynamicUpdateSql) {
                DynamicUpdateSql anotherobj = (DynamicUpdateSql)obj;
                return this.sql.equals(anotherobj.sql);
            }
            return false;
        }

        public int hashCode() {
            return this.sql.hashCode();
        }
    }
}

