/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.hibernate.template.impl;

import com.huawei.uflight.hibernate.template.HibernateTemplateException;
import com.huawei.uflight.hibernate.template.ICascadeInsert;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.StatelessSession;
import org.hibernate.engine.CascadeStyle;
import org.hibernate.engine.CascadingAction;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.jdbc.Expectation;
import org.hibernate.jdbc.Expectations;
import org.hibernate.persister.collection.AbstractCollectionPersister;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.proxy.HibernateProxyHelper;
import org.hibernate.sql.Insert;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.DiscriminatorType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CascadeInsertImpl
implements ICascadeInsert {
    private static final Logger LOGGER = LoggerFactory.getLogger(CascadeInsertImpl.class);
    private static final CascadingAction INSERT_CASCADE = CascadingAction.SAVE_UPDATE;

    @Override
    public <T> void insert(Collection<T> objects, SessionImplementor session, SessionFactoryImplementor factory) throws HibernateTemplateException {
        if (objects == null || objects.isEmpty()) {
            return;
        }
        try {
            this.executeInsert(objects, session, factory);
        }
        catch (Exception e) {
            throw new HibernateTemplateException("insert objects fails:" + objects, e);
        }
    }

    protected <T> void executeInsert(Collection<T> objects, SessionImplementor session, SessionFactoryImplementor factory) throws HibernateException, SQLException {
        if (objects == null || objects.isEmpty()) {
            return;
        }
        StatelessSession stateless = (StatelessSession)session;
        for (T object : objects) {
            stateless.insert(object);
        }
        String entityName = HibernateProxyHelper.getClassWithoutInitializingProxy(objects.iterator().next()).getName();
        AbstractEntityPersister persister = (AbstractEntityPersister)factory.getEntityPersister(entityName);
        Type[] types = persister.getPropertyTypes();
        CascadeStyle[] styles = persister.getPropertyCascadeStyles();
        for (int i = 0; i < types.length; ++i) {
            if (!this.isCascadeSave(types[i], styles[i])) continue;
            if (this.isValueCollection((AssociationType)types[i], factory)) {
                CollectionType colType = (CollectionType)types[i];
                this.insertValueCollection(objects, i, persister, colType, session, factory);
                continue;
            }
            this.insertChild(objects, i, persister, session, factory);
        }
    }

    protected <T> void insertChild(Collection<T> parents, int propertyIndex, AbstractEntityPersister persister, SessionImplementor session, SessionFactoryImplementor factory) throws HibernateException, SQLException {
        LinkedList<Object> children = new LinkedList<Object>();
        for (T object : parents) {
            Object child = persister.getPropertyValue(object, propertyIndex, EntityMode.POJO);
            if (child == null) continue;
            if (child instanceof Collection) {
                children.addAll((Collection)child);
                continue;
            }
            children.add(child);
        }
        this.executeInsert(children, session, factory);
    }

    protected <T> void insertValueCollection(Collection<T> parents, int propertyIndex, AbstractEntityPersister persister, CollectionType type, SessionImplementor session, SessionFactoryImplementor factory) throws HibernateException, SQLException {
        CollectionPersister colPersister = factory.getCollectionPersister(type.getRole());
        Joinable joinable = type.getAssociatedJoinable(factory);
        Insert insert = new Insert(factory.getDialect());
        insert.setTableName(joinable.getTableName());
        insert.addColumns(joinable.getKeyColumnNames());
        insert.addColumns(((AbstractCollectionPersister)colPersister).getElementColumnNames());
        String sql = insert.toStatementString();
        Expectation expectation = Expectations.NONE;
        for (T parent : parents) {
            Collection children = (Collection)persister.getPropertyValue(parent, propertyIndex, EntityMode.POJO);
            if (children == null || children.isEmpty()) {
                LOGGER.debug("Object []'s child [] is empty.", new Object[]{parent, persister.getPropertyNames()[propertyIndex]});
                continue;
            }
            for (Object child : children) {
                PreparedStatement ps = session.getBatcher().prepareBatchStatement(sql);
                expectation.prepare(ps);
                int index = 1;
                persister.getIdentifierType().nullSafeSet(ps, parent, index, session);
                type.getElementType(factory).nullSafeSet(ps, child, index += joinable.getKeyColumnNames().length, session);
                session.getBatcher().addToBatch(expectation);
            }
        }
    }

    protected boolean isCascadeSave(Type type, CascadeStyle style) {
        return style.doCascade(INSERT_CASCADE) && (type instanceof CollectionType || type instanceof OneToOneType || type instanceof ManyToOneType);
    }

    protected boolean isValueCollection(AssociationType type, SessionFactoryImplementor factory) {
        CollectionType colType;
        return type instanceof CollectionType && (colType = (CollectionType)type).getElementType(factory) instanceof DiscriminatorType;
    }
}

