/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.hibernate.template.impl;

import com.huawei.uflight.hibernate.template.CascadeOperationFactory;
import com.huawei.uflight.hibernate.template.HibernateTemplateException;
import com.huawei.uflight.hibernate.template.ICascadeDelete;
import com.huawei.uflight.hibernate.template.IDeleteForeignKeyHandler;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import org.hibernate.HibernateException;
import org.hibernate.engine.CascadeStyle;
import org.hibernate.engine.CascadingAction;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.jdbc.Expectation;
import org.hibernate.jdbc.Expectations;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxyHelper;
import org.hibernate.sql.Delete;
import org.hibernate.type.CollectionType;
import org.hibernate.type.DiscriminatorType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CascadeDeleteImpl
implements ICascadeDelete {
    private static final Logger LOGGER = LoggerFactory.getLogger(CascadeDeleteImpl.class);
    private static final CascadingAction DELETE_CASCADE = CascadingAction.DELETE;
    private static final Expectation EXPECTATION = Expectations.NONE;

    @Override
    public <T> void delete(Collection<T> objects, SessionImplementor session, SessionFactoryImplementor factory) throws HibernateTemplateException {
        this.delete(objects, null, session, factory);
    }

    @Override
    public <T> void delete(Collection<T> objects, IDeleteForeignKeyHandler foreignKey, SessionImplementor session, SessionFactoryImplementor factory) throws HibernateTemplateException {
        if (objects == null || objects.isEmpty()) {
            LOGGER.debug("delete collection is empty.");
            return;
        }
        String entityName = HibernateProxyHelper.getClassWithoutInitializingProxy(objects.iterator().next()).getName();
        if (foreignKey == null) {
            foreignKey = CascadeOperationFactory.getInstance().find(entityName, IDeleteForeignKeyHandler.class);
        }
        AbstractEntityPersister persister = (AbstractEntityPersister)factory.getEntityPersister(entityName);
        try {
            LinkedList<String> offsprings = new LinkedList<String>();
            this.getOffspringClass(entityName, factory, offsprings);
            Iterator iterator = offsprings.iterator();
            while (iterator.hasNext()) {
                this.deleteChild(objects, persister, foreignKey, (String)iterator.next(), factory, session);
            }
            Delete delete = new Delete();
            delete.setTableName(persister.getTableName());
            delete.setPrimaryKeyColumnNames(persister.getIdentifierColumnNames());
            for (T object : objects) {
                this.executeDelete(object, persister, delete, session);
            }
        }
        catch (Exception e) {
            throw new HibernateTemplateException("delete objects fail:" + objects, e);
        }
    }

    protected <T> void deleteChild(Collection<T> parents, AbstractEntityPersister persister, IDeleteForeignKeyHandler foreignKey, String childTable, SessionFactoryImplementor factory, SessionImplementor session) throws HibernateException, SQLException {
        Delete delete = new Delete();
        delete.setTableName(childTable);
        foreignKey.where(persister, factory, delete);
        for (T object : parents) {
            String sql = delete.toStatementString();
            PreparedStatement ps = session.getBatcher().prepareBatchStatement(sql);
            EXPECTATION.prepare(ps);
            foreignKey.dehydrate(object, persister, factory, session, ps, 1);
            session.getBatcher().addToBatch(EXPECTATION);
        }
    }

    protected <T> void executeDelete(T parent, AbstractEntityPersister persister, Delete delete, SessionImplementor session) throws HibernateException, SQLException {
        String sql = delete.toStatementString();
        PreparedStatement ps = session.getBatcher().prepareBatchStatement(sql);
        EXPECTATION.prepare(ps);
        Type identifierType = persister.getIdentifierType();
        identifierType.nullSafeSet(ps, (Object)persister.getIdentifier(parent, session.getEntityMode()), 1, session);
        session.getBatcher().addToBatch(EXPECTATION);
    }

    protected void getOffspringClass(String entityName, SessionFactoryImplementor factory, Deque<String> offspringTables) {
        EntityPersister meta = factory.getEntityPersister(entityName);
        Type[] types = meta.getPropertyTypes();
        CascadeStyle[] styles = meta.getPropertyCascadeStyles();
        for (int i = 0; i < types.length; ++i) {
            if (!this.doCascadeDelete(styles[i])) continue;
            String childAssociateName = null;
            if (types[i] instanceof CollectionType) {
                CollectionType collectionType = (CollectionType)types[i];
                offspringTables.offerFirst(collectionType.getAssociatedJoinable(factory).getTableName());
                if (!(collectionType.getElementType(factory) instanceof DiscriminatorType)) {
                    childAssociateName = collectionType.getAssociatedEntityName(factory);
                }
            } else if (types[i] instanceof EntityType) {
                EntityType entityType = (EntityType)types[i];
                offspringTables.offerFirst(entityType.getAssociatedJoinable(factory).getTableName());
                childAssociateName = entityType.getAssociatedEntityName();
            }
            if (childAssociateName == null) continue;
            this.getOffspringClass(childAssociateName, factory, offspringTables);
        }
    }

    protected boolean doCascadeDelete(CascadeStyle style) {
        return style.hasOrphanDelete() || style.doCascade(DELETE_CASCADE);
    }
}

