/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.hibernate.template;

import com.huawei.uflight.hibernate.ISessionFactoryConfigurator;
import com.huawei.uflight.hibernate.impl.SessionFactoryConfigurator;
import com.huawei.uflight.hibernate.template.IHibernateTemplate;
import com.huawei.uflight.hibernate.template.impl.HibernateTemplateImpl;
import com.huawei.uflight.hibernate.template.transaction.TransactionSessionFactoryConfigurator;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateTemplateFactory {
    public static final String ENABLE_TRANSACTION = HibernateTemplateFactory.class.getName() + ".EnableTransaction";
    private static final String DEFAULT_CONFIGFILE = "conf/hibernate.cfg.xml";
    private static final Logger log = LoggerFactory.getLogger(HibernateTemplateFactory.class);
    private static final HibernateTemplateFactory _Instance = new HibernateTemplateFactory();
    private Map<String, IHibernateTemplate> templatesCache = new HashMap<String, IHibernateTemplate>();
    private Map<String, String> url2DbName = new HashMap<String, String>();

    public static HibernateTemplateFactory getInstance() {
        return _Instance;
    }

    public synchronized IHibernateTemplate getHibernateTemplate(URL url, String dbName, Properties confProp) {
        if (null == url) {
            log.error("url is null, dbName ---> " + dbName);
            throw new IllegalArgumentException("url is null");
        }
        IHibernateTemplate template = this.templatesCache.get(url.toString());
        if (null != template) {
            return template;
        }
        ISessionFactoryConfigurator configurator = this.createSessionFactoryConfigurator(url, confProp, dbName);
        configurator.initSessionFactory();
        HibernateTemplateImpl templateImpl = new HibernateTemplateImpl(configurator);
        if (null != templateImpl) {
            templateImpl.addStateChangeListener(new HibernateTemplateImpl.IStateChangeListener(){

                @Override
                public void release(URL url) {
                    HibernateTemplateFactory.this.templatesCache.remove(url.toString());
                }
            });
            this.templatesCache.put(url.toString(), templateImpl);
            this.url2DbName.put(dbName, url.toString());
        }
        return templateImpl;
    }

    public synchronized void refreshCache(String dbName) {
        String urlStr = this.url2DbName.get(dbName);
        if (urlStr != null) {
            this.templatesCache.remove(urlStr);
        }
    }

    private ISessionFactoryConfigurator createSessionFactoryConfigurator(URL url, Properties confProp, String dbName) {
        if (null == confProp || !confProp.containsKey(ENABLE_TRANSACTION)) {
            return new SessionFactoryConfigurator(url, confProp, dbName);
        }
        String enableTransactionStr = confProp.getProperty(ENABLE_TRANSACTION);
        if (Boolean.valueOf(enableTransactionStr).booleanValue()) {
            return new TransactionSessionFactoryConfigurator(new SessionFactoryConfigurator(url, confProp, dbName));
        }
        return new SessionFactoryConfigurator(url, confProp, dbName);
    }

    public synchronized IHibernateTemplate getHibernateTemplate(URL url, String dbName) {
        return this.getHibernateTemplate(url, dbName, null);
    }

    public synchronized IHibernateTemplate getHibernateTemplate(String dbName) {
        return this.getHibernateTemplate(DEFAULT_CONFIGFILE, dbName);
    }

    public synchronized IHibernateTemplate getHibernateTemplate(String configFile, String dbName, Properties confProp) {
        return this.getHibernateTemplate(this.getURLByFile(configFile), dbName, confProp);
    }

    public synchronized IHibernateTemplate getHibernateTemplate(String configFile, String dbName) {
        return this.getHibernateTemplate(configFile, dbName, null);
    }

    private URL getURLByFile(String confFile) {
        String configFile = null;
        configFile = null == confFile || "".equals(confFile) ? DEFAULT_CONFIGFILE : confFile;
        File file = new File(configFile);
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            log.error(e.getMessage());
            return null;
        }
    }
}

