/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.hibernate.template;

import com.huawei.uflight.hibernate.template.ICascadeDelete;
import com.huawei.uflight.hibernate.template.ICascadeInsert;
import com.huawei.uflight.hibernate.template.ICascadeUpdate;
import com.huawei.uflight.hibernate.template.IDeleteForeignKeyHandler;
import com.huawei.uflight.hibernate.template.IRelationLifeCycle;
import com.huawei.uflight.hibernate.template.impl.CascadeDeleteImpl;
import com.huawei.uflight.hibernate.template.impl.CascadeInsertImpl;
import com.huawei.uflight.hibernate.template.impl.CascadeUpdateImpl;
import com.huawei.uflight.hibernate.template.impl.DefaultRelationLifeCycle;
import com.huawei.uflight.hibernate.template.impl.ForeignKeyImpl;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections.map.LRUMap;

public class CascadeOperationFactory {
    private static final CascadeOperationFactory SELF = new CascadeOperationFactory();
    private static final Object[] DEAFULT_CASCADES = new Object[5];
    private static final int CASCADE_INSERT = 0;
    private static final int CASCADE_DELETE = 1;
    private static final int CASCADE_UPDATE = 2;
    private static final int CASCADE_DELETE_FOREIGNKEY_HANDLER = 3;
    private static final int CASCADE_RELATION_LIFECYCLE = 4;
    private static final int CASCADE_COUNT = 5;
    private Map cascadeMap = Collections.synchronizedMap(new LRUMap());

    public static CascadeOperationFactory getInstance() {
        return SELF;
    }

    private CascadeOperationFactory() {
    }

    public void registryDefault(Object cascade) {
        if (cascade == null) {
            return;
        }
        if (cascade instanceof ICascadeInsert) {
            CascadeOperationFactory.DEAFULT_CASCADES[0] = cascade;
        } else if (cascade instanceof ICascadeDelete) {
            CascadeOperationFactory.DEAFULT_CASCADES[1] = cascade;
        } else if (cascade instanceof ICascadeUpdate) {
            CascadeOperationFactory.DEAFULT_CASCADES[2] = cascade;
        } else if (cascade instanceof IDeleteForeignKeyHandler) {
            CascadeOperationFactory.DEAFULT_CASCADES[3] = cascade;
        } else if (cascade instanceof IRelationLifeCycle) {
            CascadeOperationFactory.DEAFULT_CASCADES[4] = cascade;
        }
    }

    public void registry(Class clazz, Object cascade) {
        Object[] cascades = (Object[])this.cascadeMap.get(clazz);
        if (cascades == null) {
            cascades = new Object[5];
            this.cascadeMap.put(clazz, cascades);
        }
        if (cascade instanceof ICascadeInsert) {
            cascades[0] = cascade;
        } else if (cascade instanceof ICascadeDelete) {
            cascades[1] = cascade;
        } else if (cascade instanceof ICascadeUpdate) {
            cascades[2] = cascade;
        } else if (cascade instanceof IDeleteForeignKeyHandler) {
            cascades[3] = cascade;
        } else if (cascade instanceof IRelationLifeCycle) {
            cascades[4] = cascade;
        }
    }

    public <T> T find(Class clazz, Class<T> cascadeClass) {
        return this.find(clazz == null ? null : clazz.getName(), cascadeClass);
    }

    public <T> T find(String entityName, Class<T> cascadeClass) {
        Object[] cascades = null;
        if (entityName == null) {
            cascades = DEAFULT_CASCADES;
        } else {
            cascades = (Object[])this.cascadeMap.get(entityName);
            if (cascades == null) {
                cascades = DEAFULT_CASCADES;
            }
        }
        if (ICascadeInsert.class.isAssignableFrom(cascadeClass)) {
            return (T)cascades[0];
        }
        if (ICascadeDelete.class.isAssignableFrom(cascadeClass)) {
            return (T)cascades[1];
        }
        if (ICascadeUpdate.class.isAssignableFrom(cascadeClass)) {
            return (T)cascades[2];
        }
        if (IDeleteForeignKeyHandler.class.isAssignableFrom(cascadeClass)) {
            return (T)cascades[3];
        }
        if (IRelationLifeCycle.class.isAssignableFrom(cascadeClass)) {
            return (T)cascades[4];
        }
        return null;
    }

    static {
        CascadeOperationFactory.DEAFULT_CASCADES[0] = new CascadeInsertImpl();
        CascadeOperationFactory.DEAFULT_CASCADES[1] = new CascadeDeleteImpl();
        CascadeOperationFactory.DEAFULT_CASCADES[2] = new CascadeUpdateImpl();
        CascadeOperationFactory.DEAFULT_CASCADES[3] = new ForeignKeyImpl();
        CascadeOperationFactory.DEAFULT_CASCADES[4] = new DefaultRelationLifeCycle();
    }
}

