/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.hibernate.impl;

import com.huawei.commextend.frameutil.DBInfo;
import com.huawei.commextend.frameutil.DBInfoQuery;
import com.huawei.uflight.hibernate.ISessionFactoryConfigurator;
import com.huawei.uflight.hibernate.impl.ExtensionCache;
import com.huawei.uflight.hibernate.impl.SessionCache;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionFactoryConfigurator
implements ISessionFactoryConfigurator {
    private static final String CONNECTION_DRIVER_CLASS_KEY = "hibernate.connection.driver_class";
    private static final String CONNECTION_URL_KEY = "hibernate.connection.url";
    private static final String CONNECTION_USERNAME_KEY = "hibernate.connection.username";
    private static final String CONNECTION_PASSWORD_KEY = "hibernate.connection.password";
    private static final String DIALECT_KEY = "hibernate.dialect";
    private static final String DEFAULT_SCHEMA = "hibernate.default_schema";
    private URL configURL = null;
    private String dbName = null;
    private Properties properties = null;
    private SessionFactory sf;
    private static final Logger log = LoggerFactory.getLogger(SessionCache.class);

    public SessionFactoryConfigurator(URL configURL, String dbName) {
        this.configURL = configURL;
        this.dbName = dbName;
    }

    public SessionFactoryConfigurator(URL configURL, Properties properties, String dbName) {
        this.configURL = configURL;
        this.properties = properties;
        this.dbName = dbName;
    }

    @Override
    public void closeSessionFactory() {
        try {
            if (null != this.sf) {
                this.sf.close();
                this.sf = null;
            }
        }
        catch (Exception e) {
            log.error("closeSessionFactory() error, the url = " + this.configURL, (Throwable)e);
        }
    }

    @Override
    public void initSessionFactory() {
        try {
            List<Class> poClasses;
            this.closeSessionFactory();
            Configuration config = new Configuration().configure(this.configURL);
            if (null != this.properties) {
                config.addProperties(this.properties);
            }
            if (null == this.dbName || "".equals(this.dbName.trim())) {
                log.error("initSessionFactory() error, the dbName is null.");
                return;
            }
            if (this.isIntegrated()) {
                Properties extraProperties = this.getDataSourcePro();
                config.addProperties(extraProperties);
            }
            if (null == (poClasses = ExtensionCache.getInstance().get(this.dbName)) || poClasses.isEmpty()) {
                log.warn("The db not config class mapping, dbName=" + this.dbName);
            } else {
                for (Class poClass : poClasses) {
                    config.addClass(poClass);
                }
            }
            this.sf = config.buildSessionFactory();
        }
        catch (Exception e) {
            log.error("initSessionFactory() error, the url = " + this.configURL, (Throwable)e);
        }
    }

    public Properties getDataSourcePro() {
        Properties databasePro = new Properties();
        try {
            DBInfo dbInfo = DBInfoQuery.getDBConfInfo((String)this.dbName);
            if (this.dbName.equals(dbInfo.getDbName())) {
                databasePro.put(DIALECT_KEY, this.getDialect(dbInfo.getDbType()));
                databasePro.put(CONNECTION_DRIVER_CLASS_KEY, DBInfoQuery.getDBDriver((int)dbInfo.getDbType()));
                databasePro.put(CONNECTION_URL_KEY, DBInfoQuery.getDBConnURL((DBInfo)dbInfo));
                databasePro.put(CONNECTION_USERNAME_KEY, dbInfo.getDbUserName());
                databasePro.put(CONNECTION_PASSWORD_KEY, dbInfo.getDbPasswd());
                if (dbInfo.getDbType() == 2) {
                    databasePro.put(DEFAULT_SCHEMA, dbInfo.getDbName());
                }
            }
        }
        catch (Exception e) {
            log.error("getDataSourcePro(" + this.dbName + ") error.", (Throwable)e);
        }
        return databasePro;
    }

    @Override
    public SessionFactory getSessionFactory() {
        return this.sf;
    }

    @Override
    public URL getURL() {
        return this.configURL;
    }

    private String getDialect(int dbType) {
        switch (dbType) {
            case 0: {
                return "org.hibernate.dialect.SybaseDialect";
            }
            case 1: {
                return "org.hibernate.dialect.SQLServerDialect";
            }
            case 2: {
                return "org.hibernate.dialect.Oracle10gDialect";
            }
        }
        return "org.hibernate.dialect.HSQLDialect";
    }

    public boolean isIntegrated() {
        String deployModeProp = System.getProperty("deploymentMode");
        return null == deployModeProp ? false : "integrated".equalsIgnoreCase(deployModeProp.trim());
    }
}

