/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.hibernate.impl;

import com.huawei.uflight.hibernate.template.HibernateTemplateFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtensionCache {
    private static Logger log = LoggerFactory.getLogger(ExtensionCache.class);
    private static ExtensionCache instance;
    private Map<String, List<Class>> poClassMap = new HashMap<String, List<Class>>();

    private ExtensionCache() {
    }

    public static synchronized ExtensionCache getInstance() {
        if (null == instance) {
            instance = new ExtensionCache();
        }
        return instance;
    }

    public synchronized void add(IExtensionRegistry registry) {
        IExtension[] extensions = registry.getExtensionPoint("com.huawei.uflight.persistent.hibernateExtension").getExtensions();
        if (null == extensions) {
            return;
        }
        for (int i = 0; i < extensions.length; ++i) {
            this.add(extensions[i]);
        }
    }

    public synchronized void add(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        try {
            for (int j = 0; j < elements.length; ++j) {
                Class<?> poClass = elements[j].createExecutableExtension("class").getClass();
                String dbName = elements[j].getAttribute("dbName");
                if (null == dbName) {
                    log.error("The extension is invalidate, dbName is null. poClass=" + poClass.getName());
                    continue;
                }
                if ("".equals(dbName.trim()) && null == (dbName = System.getProperty("dbName"))) {
                    log.error("The System Property dbName is null. poClass=" + poClass.getName());
                    continue;
                }
                List<Class> classes = this.get(dbName);
                if (null == classes) {
                    classes = new CopyOnWriteArrayList<Class>();
                    this.poClassMap.put(dbName, classes);
                } else {
                    HibernateTemplateFactory.getInstance().refreshCache(dbName);
                }
                classes.add(poClass);
                log.info("Add Class Mapping, dbName=" + dbName + ",poClass=" + poClass);
            }
        }
        catch (Exception e) {
            log.error("Add extension error.", (Throwable)e);
        }
    }

    public synchronized void remove(IExtensionRegistry registry) {
        IExtension[] extensions = registry.getExtensionPoint("com.huawei.uflight.persistent.hibernateExtension").getExtensions();
        if (null == extensions) {
            return;
        }
        for (int i = 0; i < extensions.length; ++i) {
            this.remove(extensions[i]);
        }
    }

    public synchronized void remove(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        try {
            for (int j = 0; j < elements.length; ++j) {
                String className = elements[j].getAttribute("class");
                String dbName = elements[j].getAttribute("dbName");
                List<Class> classes = this.get(dbName);
                if (null != classes) {
                    for (int i = classes.size() - 1; i >= 0; --i) {
                        Class one = classes.get(i);
                        if (!one.getName().equals(className)) continue;
                        classes.remove(one);
                    }
                }
                log.info("Remove Class Mapping, className=" + className);
            }
        }
        catch (Exception e) {
            log.error("Remove extension error.", (Throwable)e);
        }
    }

    public List<Class> get(String dbName) {
        if (null == dbName) {
            return null;
        }
        return this.poClassMap.get(dbName);
    }
}

