/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.hibernate;

import com.huawei.uflight.hibernate.Dao;
import com.huawei.uflight.hibernate.impl.SessionCache;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DaoFactory {
    private static DaoFactory instance;
    private static final String DEFAULT_CONFIGFILE = "conf/hibernate.cfg.xml";
    private static final Logger log;
    private Map<String, Dao> daoCache = new HashMap<String, Dao>();

    public static synchronized DaoFactory getInstance() {
        if (null == instance) {
            instance = new DaoFactory();
        }
        return instance;
    }

    private DaoFactory() {
    }

    public synchronized Dao getDao(String dbName) {
        return this.getDao(DEFAULT_CONFIGFILE, dbName);
    }

    public synchronized Dao getDao(String confFile, String dbName) {
        return this.getDao(confFile, null, dbName);
    }

    public synchronized Dao getDao(String confFile, Properties properties, String dbName) {
        URL confFileURL = this.getURLByFile(confFile);
        if (null == confFileURL) {
            return null;
        }
        return this.getDao(confFileURL, properties, dbName);
    }

    private URL getURLByFile(String confFile) {
        String configFile = null;
        configFile = null == confFile || "".equals(confFile) ? DEFAULT_CONFIGFILE : confFile;
        File file = new File(configFile);
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public synchronized Dao getDao(URL confFileURL, Properties properties, String dbName) {
        Dao dao = this.daoCache.get(confFileURL.toString());
        if (null != dao) {
            return dao;
        }
        SessionCache sessionCache = new SessionCache(confFileURL, properties, dbName);
        sessionCache.initSessionFactory();
        dao = new Dao(sessionCache);
        if (null != dao) {
            this.daoCache.put(confFileURL.toString(), dao);
        }
        return dao;
    }

    public synchronized Dao getDao(URL confFileURL, String dbName) {
        return this.getDao(confFileURL, null, dbName);
    }

    public synchronized Map<String, Dao> getDaoCache() {
        return this.daoCache;
    }

    public synchronized void closeDao(String confFile) {
        URL confFileURL = this.getURLByFile(confFile);
        if (null == confFileURL) {
            return;
        }
        this.closeDao(confFileURL);
    }

    public synchronized void closeDao(URL confFileURL) {
        Dao dao = this.daoCache.get(confFileURL.toString());
        if (null == dao) {
            return;
        }
        dao.getService().closeSessionFactory();
        this.daoCache.remove(confFileURL.toString());
    }

    static {
        log = LoggerFactory.getLogger(DaoFactory.class);
    }
}

