/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.hibernate;

import com.huawei.uflight.hibernate.impl.SessionService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dao {
    private static final Logger log = LoggerFactory.getLogger(Dao.class);
    private SessionService service;

    public Dao(SessionService sessionCache) {
        this.service = sessionCache;
    }

    public void save(Object obj) {
        ArrayList<Object> objLst = new ArrayList<Object>();
        objLst.add(obj);
        this.saveAll(objLst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAll(List<Object> lstObj) {
        Session _session = this.service.get();
        Transaction tx = _session.beginTransaction();
        try {
            int size = lstObj.size();
            for (int i = 0; i < size; ++i) {
                Object obj = lstObj.get(i);
                _session.saveOrUpdate(obj);
            }
            tx.commit();
        }
        catch (HibernateException e) {
            tx.rollback();
            log.error(e.toString());
        }
        finally {
            this.service.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Object obj) {
        Session _session = this.service.get();
        Transaction tx = _session.beginTransaction();
        try {
            _session.update(obj);
            tx.commit();
        }
        catch (HibernateException e) {
            tx.rollback();
            log.error("update() error.", (Throwable)e);
        }
        finally {
            this.service.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateByHql(String hql, Map<String, Object> params) {
        Session _session = this.service.get();
        Transaction tx = _session.beginTransaction();
        try {
            Query query = _session.createQuery("update " + hql);
            if (params != null) {
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    query.setParameter(entry.getKey(), entry.getValue());
                }
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            log.error("updateByHql() error", (Throwable)e);
        }
        finally {
            this.service.free();
        }
    }

    public void delete(Object obj) {
        ArrayList<Object> objLst = new ArrayList<Object>();
        objLst.add(obj);
        this.deleteObjLst(objLst);
    }

    public void deleteById(Class po, int id) {
        Object obj = this.getById(po, id);
        this.delete(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll(Class po) {
        Session _session = this.service.get();
        Transaction tx = _session.beginTransaction();
        try {
            _session.createQuery("delete from " + po.getName()).executeUpdate();
            tx.commit();
        }
        catch (HibernateException e) {
            tx.rollback();
            log.error("deleteAll(" + po.getName() + ") error.", (Throwable)e);
        }
        finally {
            this.service.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObjLst(List<Object> objLst) {
        Session _session = this.service.get();
        Transaction tx = _session.beginTransaction();
        try {
            for (Object obj : objLst) {
                _session.delete(obj);
            }
            tx.commit();
        }
        catch (HibernateException e) {
            tx.rollback();
            log.error("deleteObjLst() error.", (Throwable)e);
        }
        finally {
            this.service.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteByHql(String hql, Map<String, Object> params) {
        Session _session = this.service.get();
        int count = 0;
        Transaction tx = _session.beginTransaction();
        try {
            Query query = _session.createQuery("delete from " + hql);
            if (params != null) {
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    query.setParameter(entry.getKey(), entry.getValue());
                }
            }
            count = query.executeUpdate();
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            log.error("deleteByHql() error", (Throwable)e);
        }
        finally {
            this.service.free();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getById(Class po, int id) {
        Session _session = this.service.get();
        Object obj = null;
        try {
            obj = _session.get(po, (Serializable)Integer.valueOf(id));
        }
        catch (Exception e) {
            log.error("getById() error, po=" + po.getName() + ",id=" + id, (Throwable)e);
        }
        finally {
            this.service.free();
        }
        return obj;
    }

    public int getCount(String hql) {
        return this.getCount(hql, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount(String hql, Map params) {
        String sql = hql;
        Session _session = this.service.get();
        String tmpHql = hql.toLowerCase(Locale.ENGLISH);
        if (!tmpHql.startsWith("select")) {
            sql = "select count(*) " + hql;
        } else {
            tmpHql = hql.substring(tmpHql.indexOf("from"));
            sql = "select count(*) " + tmpHql;
        }
        int i = 0;
        try {
            Query query = _session.createQuery(sql);
            if (params != null) {
                for (Map.Entry entry : params.entrySet()) {
                    query.setParameter((String)entry.getKey(), entry.getValue());
                }
            }
            if (query.iterate().hasNext()) {
                i = ((Long)query.iterate().next()).intValue();
            }
        }
        catch (Exception e) {
            log.error("getCount() error", (Throwable)e);
        }
        finally {
            this.service.free();
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getListByHql(String hql, Map params) {
        Session _session = this.service.get();
        List list = new ArrayList();
        try {
            Query query = _session.createQuery(hql);
            if (params != null) {
                for (Map.Entry entry : params.entrySet()) {
                    query.setParameter((String)entry.getKey(), entry.getValue());
                }
            }
            list = query.setCacheable(true).list();
        }
        catch (Exception e) {
            log.error("getListByHql() error", (Throwable)e);
        }
        finally {
            this.service.free();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getListByHqlAndPage(String hql, Map params, int currentPage, int pageSize) {
        int curPage = currentPage;
        Session _session = this.service.get();
        List list = new ArrayList();
        try {
            Query query = _session.createQuery(hql);
            if (null != params) {
                for (Map.Entry entry : params.entrySet()) {
                    query.setParameter((String)entry.getKey(), entry.getValue());
                }
            }
            if (curPage < 1) {
                curPage = 1;
            }
            query.setFirstResult((curPage - 1) * pageSize);
            query.setMaxResults(pageSize);
            list = query.setCacheable(true).list();
        }
        catch (Exception e) {
            log.error("getListByHqlAndPage() error", (Throwable)e);
        }
        finally {
            this.service.free();
        }
        return list;
    }

    public SessionService getService() {
        return this.service;
    }
}

