/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.io.IOException;
import java.io.OutputStream;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.AssignableFromLong;
import org.snmp4j.smi.AssignableFromString;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;

public class UnsignedInteger32
extends AbstractVariable
implements AssignableFromLong,
AssignableFromString {
    private static final long serialVersionUID = -2155365655395258383L;
    protected long value = 0L;

    public UnsignedInteger32() {
    }

    public UnsignedInteger32(long value) {
        this.setValue(value);
    }

    public UnsignedInteger32(int signedIntValue) {
        this.setValue((long)signedIntValue & 0xFFFFFFFFL);
    }

    public UnsignedInteger32(byte signedByteValue) {
        this.setValue(signedByteValue & 0xFF);
    }

    @Override
    public void encodeBER(OutputStream outputStream) throws IOException {
        BER.encodeUnsignedInteger(outputStream, (byte)66, this.value);
    }

    @Override
    public void decodeBER(BERInputStream inputStream) throws IOException {
        BER.MutableByte type = new BER.MutableByte();
        long newValue = BER.decodeUnsignedInteger(inputStream, type);
        if (type.getValue() != 66) {
            throw new IOException("Wrong type encountered when decoding Gauge: " + type.getValue());
        }
        this.setValue(newValue);
    }

    @Override
    public int getSyntax() {
        return 66;
    }

    @Override
    public int hashCode() {
        return (int)this.value;
    }

    @Override
    public int getBERLength() {
        if (this.value < 128L) {
            return 3;
        }
        if (this.value < 32768L) {
            return 4;
        }
        if (this.value < 0x800000L) {
            return 5;
        }
        if (this.value < 0x80000000L) {
            return 6;
        }
        return 7;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof UnsignedInteger32) {
            return ((UnsignedInteger32)o).value == this.value;
        }
        return false;
    }

    @Override
    public int compareTo(Variable o) {
        long diff = this.value - ((UnsignedInteger32)o).getValue();
        if (diff < 0L) {
            return -1;
        }
        if (diff > 0L) {
            return 1;
        }
        return 0;
    }

    @Override
    public String toString() {
        return Long.toString(this.value);
    }

    @Override
    public final void setValue(String value) {
        this.setValue(Long.parseLong(value));
    }

    @Override
    public void setValue(long value) {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Argument must be an unsigned 32bit value");
        }
        this.value = value;
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public Object clone() {
        return new UnsignedInteger32(this.value);
    }

    @Override
    public final int toInt() {
        return (int)this.getValue();
    }

    @Override
    public final long toLong() {
        return this.getValue();
    }

    @Override
    public OID toSubIndex(boolean impliedLength) {
        return new OID(new int[]{this.toInt()});
    }

    @Override
    public void fromSubIndex(OID subIndex, boolean impliedLength) {
        this.setValue(subIndex.getUnsigned(0));
    }
}

