/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.io.Serializable;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.AuthenticationProtocol;
import org.snmp4j.security.DecryptParams;
import org.snmp4j.security.PrivacyProtocol;
import org.snmp4j.security.Salt;
import org.snmp4j.smi.OctetString;

public abstract class PrivAES
implements PrivacyProtocol {
    private static final int DECRYPT_PARAMS_LENGTH = 8;
    private static final LogAdapter logger = LogFactory.getLogger(PrivAES.class);
    private int keyBytes;
    protected Salt salt;

    public PrivAES(int keyBytes) {
        if (keyBytes != 16 && keyBytes != 24 && keyBytes != 32) {
            throw new IllegalArgumentException("Only 128, 192 and 256 bit AES is allowed. Requested (" + 8 * keyBytes + ").");
        }
        this.keyBytes = keyBytes;
        this.salt = Salt.getInstance();
    }

    @Override
    public byte[] encrypt(byte[] unencryptedData, int offset, int length, byte[] encryptionKey, long engineBoots, long engineTime, DecryptParams decryptParams) {
        byte[] initVect = new byte[16];
        long my_salt = this.salt.getNext();
        if (encryptionKey.length < this.keyBytes) {
            throw new IllegalArgumentException("Needed key length is " + this.keyBytes + ". Got only " + encryptionKey.length + ".");
        }
        if (decryptParams.array == null || decryptParams.length < 8) {
            decryptParams.array = new byte[8];
        }
        decryptParams.length = 8;
        decryptParams.offset = 0;
        initVect[0] = (byte)(engineBoots >> 24 & 0xFFL);
        initVect[1] = (byte)(engineBoots >> 16 & 0xFFL);
        initVect[2] = (byte)(engineBoots >> 8 & 0xFFL);
        initVect[3] = (byte)(engineBoots & 0xFFL);
        initVect[4] = (byte)(engineTime >> 24 & 0xFFL);
        initVect[5] = (byte)(engineTime >> 16 & 0xFFL);
        initVect[6] = (byte)(engineTime >> 8 & 0xFFL);
        initVect[7] = (byte)(engineTime & 0xFFL);
        int i = 56;
        int j = 8;
        while (i >= 0) {
            initVect[j] = (byte)(my_salt >> i & 0xFFL);
            i -= 8;
            ++j;
        }
        System.arraycopy(initVect, 8, decryptParams.array, 0, 8);
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("initVect is " + PrivAES.asHex(initVect))));
        }
        byte[] encryptedData = null;
        try {
            Cipher alg = Cipher.getInstance("AES/CFB/NoPadding");
            SecretKeySpec key = new SecretKeySpec(encryptionKey, 0, this.keyBytes, "AES");
            IvParameterSpec ivSpec = new IvParameterSpec(initVect);
            alg.init(1, (Key)key, ivSpec);
            encryptedData = alg.doFinal(unencryptedData, offset, length);
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("aes encrypt: Data to encrypt " + PrivAES.asHex(unencryptedData))));
                logger.debug((Serializable)((Object)("aes encrypt: used key " + PrivAES.asHex(encryptionKey))));
                logger.debug((Serializable)((Object)("aes encrypt: created privacy_params " + PrivAES.asHex(decryptParams.array))));
                logger.debug((Serializable)((Object)("aes encrypt: encrypted Data  " + PrivAES.asHex(encryptedData))));
            }
        }
        catch (Exception e) {
            logger.error((Serializable)((Object)("Encrypt Exception " + e)));
        }
        return encryptedData;
    }

    @Override
    public byte[] decrypt(byte[] cryptedData, int offset, int length, byte[] decryptionKey, long engineBoots, long engineTime, DecryptParams decryptParams) {
        byte[] initVect = new byte[16];
        if (decryptionKey.length < this.keyBytes) {
            throw new IllegalArgumentException("Needed key length is " + this.keyBytes + ". Got only " + decryptionKey.length + ".");
        }
        initVect[0] = (byte)(engineBoots >> 24 & 0xFFL);
        initVect[1] = (byte)(engineBoots >> 16 & 0xFFL);
        initVect[2] = (byte)(engineBoots >> 8 & 0xFFL);
        initVect[3] = (byte)(engineBoots & 0xFFL);
        initVect[4] = (byte)(engineTime >> 24 & 0xFFL);
        initVect[5] = (byte)(engineTime >> 16 & 0xFFL);
        initVect[6] = (byte)(engineTime >> 8 & 0xFFL);
        initVect[7] = (byte)(engineTime & 0xFFL);
        System.arraycopy(decryptParams.array, decryptParams.offset, initVect, 8, 8);
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("initVect is " + PrivAES.asHex(initVect))));
        }
        byte[] decryptedData = null;
        try {
            Cipher alg = Cipher.getInstance("AES/CFB/NoPadding");
            SecretKeySpec key = new SecretKeySpec(decryptionKey, 0, this.keyBytes, "AES");
            IvParameterSpec ivSpec = new IvParameterSpec(initVect);
            alg.init(2, (Key)key, ivSpec);
            decryptedData = alg.doFinal(cryptedData, offset, length);
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("aes decrypt: Data to decrypt " + PrivAES.asHex(cryptedData))));
                logger.debug((Serializable)((Object)("aes decrypt: used key " + PrivAES.asHex(decryptionKey))));
                logger.debug((Serializable)((Object)("aes decrypt: used privacy_params " + PrivAES.asHex(decryptParams.array))));
                logger.debug((Serializable)((Object)("aes decrypt: decrypted Data  " + PrivAES.asHex(decryptedData))));
            }
        }
        catch (Exception e) {
            logger.error((Serializable)((Object)("Decrypt Exception " + e)));
        }
        return decryptedData;
    }

    @Override
    public int getEncryptedLength(int scopedPDULength) {
        return scopedPDULength;
    }

    public static String asHex(byte[] buf) {
        return new OctetString(buf).toHexString();
    }

    @Override
    public int getMinKeyLength() {
        return this.keyBytes;
    }

    @Override
    public int getMaxKeyLength() {
        return this.getMinKeyLength();
    }

    @Override
    public int getDecryptParamsLength() {
        return 8;
    }

    @Override
    public byte[] extendShortKey(byte[] shortKey, OctetString password, byte[] engineID, AuthenticationProtocol authProtocol) {
        int bytesToCopy;
        int length;
        byte[] extKey = new byte[this.getMinKeyLength()];
        System.arraycopy(shortKey, 0, extKey, 0, length);
        for (length = shortKey.length; length < extKey.length; length += bytesToCopy) {
            byte[] hash = authProtocol.hash(extKey, 0, length);
            if (hash == null) {
                return null;
            }
            bytesToCopy = extKey.length - length;
            if (bytesToCopy > authProtocol.getDigestLength()) {
                bytesToCopy = authProtocol.getDigestLength();
            }
            System.arraycopy(hash, 0, extKey, length, bytesToCopy);
        }
        return extKey;
    }
}

