/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.util;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class ThreadPool
implements Executor {
    private static final int CORE_THREAD_COUNT = 10;
    private static final ThreadPool INSTANCE = new ThreadPool();
    private ExecutorService executor = Executors.newFixedThreadPool(10);

    private ThreadPool() {
        Runtime.getRuntime().addShutdownHook(new Thread("Thread pool shut down hook"){

            @Override
            public void run() {
                ThreadPool.this.executor.shutdown();
            }
        });
    }

    public static ThreadPool getInstance() {
        return INSTANCE;
    }

    @Override
    public void execute(Runnable event) {
        if (this.executor.isShutdown()) {
            event.run();
        } else {
            this.executor.execute(event);
        }
    }
}

