/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.transport;

import com.trilead.ssh2.ConnectionInfo;
import com.trilead.ssh2.ConnectionMonitor;
import com.trilead.ssh2.DHGexParameters;
import com.trilead.ssh2.HTTPProxyData;
import com.trilead.ssh2.HTTPProxyException;
import com.trilead.ssh2.ProxyData;
import com.trilead.ssh2.ServerHostKeyVerifier;
import com.trilead.ssh2.crypto.Base64;
import com.trilead.ssh2.crypto.CryptoWishList;
import com.trilead.ssh2.crypto.cipher.BlockCipher;
import com.trilead.ssh2.crypto.digest.MAC;
import com.trilead.ssh2.log.Logger;
import com.trilead.ssh2.nio.IPacketHandler;
import com.trilead.ssh2.nio.SelectorThread;
import com.trilead.ssh2.packets.PacketDisconnect;
import com.trilead.ssh2.packets.TypesReader;
import com.trilead.ssh2.transport.ClientServerHello;
import com.trilead.ssh2.transport.KexManager;
import com.trilead.ssh2.transport.MessageHandler;
import com.trilead.ssh2.transport.TransportConnection;
import com.trilead.ssh2.util.Tokenizer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelector;
import java.security.SecureRandom;
import java.util.Vector;

public class TransportManager
implements IPacketHandler {
    private static final Logger log = Logger.getLogger(TransportManager.class);
    private final Vector asynchronousQueue = new Vector();
    private Thread asynchronousThread = null;
    String hostname;
    int port;
    private final SocketChannel socketChannel = SocketChannel.open();
    final Socket sock = this.socketChannel.socket();
    Object connectionSemaphore = new Object();
    boolean flagKexOngoing = false;
    boolean connectionClosed = false;
    Throwable reasonClosedCause = null;
    TransportConnection tc;
    KexManager km;
    Vector messageHandlers = new Vector();
    Thread receiveThread;
    Vector connectionMonitors = new Vector();
    boolean monitorsWereInformed = false;
    private ClientServerHello versions;

    private InetAddress createInetAddress(String host) throws UnknownHostException {
        InetAddress addr = this.parseIPv4Address(host);
        if (addr != null) {
            return addr;
        }
        return InetAddress.getByName(host);
    }

    private InetAddress parseIPv4Address(String host) throws UnknownHostException {
        if (host == null) {
            return null;
        }
        String[] quad = Tokenizer.parseTokens((String)host, (char)'.');
        if (quad == null || quad.length != 4) {
            return null;
        }
        byte[] addr = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int part = 0;
            if (quad[i].length() == 0 || quad[i].length() > 3) {
                return null;
            }
            for (int k = 0; k < quad[i].length(); ++k) {
                char c = quad[i].charAt(k);
                if (c < '0' || c > '9') {
                    return null;
                }
                part = part * 10 + (c - 48);
            }
            if (part > 255) {
                return null;
            }
            addr[i] = (byte)part;
        }
        return InetAddress.getByAddress(host, addr);
    }

    public TransportManager(String host, int port) throws IOException {
        this.hostname = host;
        this.port = port;
    }

    public int getPacketOverheadEstimate() {
        return this.tc.getPacketOverheadEstimate();
    }

    public void setTcpNoDelay(boolean state) throws IOException {
        this.sock.setTcpNoDelay(state);
    }

    public void setSoTimeout(int timeout) throws IOException {
        this.sock.setSoTimeout(timeout);
    }

    public ConnectionInfo getConnectionInfo(int kexNumber) throws IOException {
        return this.km.getOrWaitForConnectionInfo(kexNumber);
    }

    public ClientServerHello getVersionInfo() {
        return this.versions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable getReasonClosedCause() {
        Object object = this.connectionSemaphore;
        synchronized (object) {
            return this.reasonClosedCause;
        }
    }

    public byte[] getSessionIdentifier() {
        return this.km.sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Throwable cause, boolean useDisconnectPacket) {
        if (!useDisconnectPacket) {
            try {
                this.socketChannel.close();
                log.log(50, "socket is closed:  " + this.getConnAddressInfo());
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        Object ignore = this.connectionSemaphore;
        synchronized (ignore) {
            if (!this.connectionClosed) {
                if (useDisconnectPacket) {
                    try {
                        byte[] msg = new PacketDisconnect(11, cause.getMessage(), "").getPayload();
                        if (this.tc != null) {
                            this.tc.sendMessage(msg);
                        }
                    }
                    catch (IOException ignore2) {
                        // empty catch block
                    }
                    try {
                        this.socketChannel.close();
                        log.log(50, "socket is closed:  " + this.getConnAddressInfo());
                    }
                    catch (IOException ignore3) {
                        // empty catch block
                    }
                }
                this.connectionClosed = true;
                this.reasonClosedCause = cause;
            }
            this.connectionSemaphore.notifyAll();
        }
        Vector monitors = null;
        TransportManager ignore3 = this;
        synchronized (ignore3) {
            if (!this.monitorsWereInformed) {
                this.monitorsWereInformed = true;
                monitors = (Vector)this.connectionMonitors.clone();
            }
        }
        if (monitors != null) {
            for (int i = 0; i < monitors.size(); ++i) {
                try {
                    ConnectionMonitor cmon = (ConnectionMonitor)monitors.elementAt(i);
                    cmon.connectionLost(this.reasonClosedCause);
                    continue;
                }
                catch (Exception ignore4) {
                    // empty catch block
                }
            }
        }
        this.notifyHandlerClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(InetSocketAddress remote, int timeout) throws IOException {
        Object object = this.socketChannel.blockingLock();
        synchronized (object) {
            block18: {
                if (!this.socketChannel.isBlocking()) {
                    throw new IllegalBlockingModeException();
                }
                if (timeout == 0) {
                    this.socketChannel.connect(remote);
                    return;
                }
                SelectionKey sk = null;
                AbstractSelector sel = null;
                this.socketChannel.configureBlocking(false);
                try {
                    long st;
                    if (this.socketChannel.connect(remote)) {
                        return;
                    }
                    sel = this.socketChannel.provider().openSelector();
                    sk = this.socketChannel.register(sel, 8);
                    long to = timeout;
                    do {
                        if (!this.socketChannel.isOpen()) {
                            throw new ClosedChannelException();
                        }
                        st = System.currentTimeMillis();
                        int ns = sel.select(to);
                        if (ns > 0 && sk.isConnectable() && this.socketChannel.finishConnect()) {
                            break block18;
                        }
                        sel.selectedKeys().remove(sk);
                    } while ((to -= System.currentTimeMillis() - st) > 0L);
                    try {
                        this.socketChannel.close();
                    }
                    catch (IOException x) {
                        // empty catch block
                    }
                    throw new SocketTimeoutException();
                }
                finally {
                    if (sk != null) {
                        sk.cancel();
                    }
                    if (this.socketChannel.isOpen()) {
                        this.socketChannel.configureBlocking(true);
                    }
                    if (sel != null) {
                        sel.selectNow();
                    }
                    ((Selector)sel).close();
                }
            }
        }
    }

    private void establishConnection(ProxyData proxyData, int connectTimeout) throws IOException {
        if (proxyData == null) {
            InetAddress addr = this.createInetAddress(this.hostname);
            this.connect(new InetSocketAddress(addr, this.port), connectTimeout);
            log.log(50, "socket is connected: " + this.getConnAddressInfo());
            this.sock.setSoTimeout(0);
            return;
        }
        if (proxyData instanceof HTTPProxyData) {
            HTTPProxyData pd = (HTTPProxyData)proxyData;
            InetAddress addr = this.createInetAddress(pd.proxyHost);
            this.connect(new InetSocketAddress(addr, pd.proxyPort), connectTimeout);
            log.log(50, "socket is connected: " + this.getConnAddressInfo());
            this.sock.setSoTimeout(0);
            StringBuffer sb = new StringBuffer();
            sb.append("CONNECT ");
            sb.append(this.hostname);
            sb.append(':');
            sb.append(this.port);
            sb.append(" HTTP/1.0\r\n");
            if (pd.proxyUser != null && pd.proxyPass != null) {
                String credentials = pd.proxyUser + ":" + pd.proxyPass;
                char[] encoded = Base64.encode((byte[])credentials.getBytes("ISO-8859-1"));
                sb.append("Proxy-Authorization: Basic ");
                sb.append(encoded);
                sb.append("\r\n");
            }
            if (pd.requestHeaderLines != null) {
                for (int i = 0; i < pd.requestHeaderLines.length; ++i) {
                    if (pd.requestHeaderLines[i] == null) continue;
                    sb.append(pd.requestHeaderLines[i]);
                    sb.append("\r\n");
                }
            }
            sb.append("\r\n");
            OutputStream out = this.sock.getOutputStream();
            out.write(sb.toString().getBytes("ISO-8859-1"));
            out.flush();
            byte[] buffer = new byte[1024];
            InputStream in = this.sock.getInputStream();
            int len = ClientServerHello.readLineRN((InputStream)in, (byte[])buffer);
            String httpReponse = new String(buffer, 0, len, "ISO-8859-1");
            if (!httpReponse.startsWith("HTTP/")) {
                throw new IOException("The proxy did not send back a valid HTTP response.");
            }
            if (httpReponse.length() < 14 || httpReponse.charAt(8) != ' ' || httpReponse.charAt(12) != ' ') {
                throw new IOException("The proxy did not send back a valid HTTP response.");
            }
            int errorCode = 0;
            try {
                errorCode = Integer.parseInt(httpReponse.substring(9, 12));
            }
            catch (NumberFormatException ignore) {
                throw new IOException("The proxy did not send back a valid HTTP response.");
            }
            if (errorCode < 0 || errorCode > 999) {
                throw new IOException("The proxy did not send back a valid HTTP response.");
            }
            if (errorCode != 200) {
                throw new HTTPProxyException(httpReponse.substring(13), errorCode);
            }
            while ((len = ClientServerHello.readLineRN((InputStream)in, (byte[])buffer)) != 0) {
            }
            return;
        }
        throw new IOException("Unsupported ProxyData");
    }

    public void initialize(CryptoWishList cwl, ServerHostKeyVerifier verifier, DHGexParameters dhgex, int connectTimeout, SecureRandom rnd, ProxyData proxyData) throws IOException {
        ClientServerHello csh;
        this.establishConnection(proxyData, connectTimeout);
        this.versions = csh = new ClientServerHello(this.sock.getInputStream(), this.sock.getOutputStream());
        this.tc = new TransportConnection(this.socketChannel, rnd);
        this.km = new KexManager(this, csh, cwl, this.hostname, this.port, verifier, rnd);
        this.km.initiateKEX(cwl, dhgex);
        this.registerSelector(SelectorThread.getSelector());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMessageHandler(MessageHandler mh, int low, int high) {
        HandlerEntry he = new HandlerEntry();
        he.mh = mh;
        he.low = low;
        he.high = high;
        Vector vector = this.messageHandlers;
        synchronized (vector) {
            this.messageHandlers.addElement(he);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageHandler(MessageHandler mh, int low, int high) {
        Vector vector = this.messageHandlers;
        synchronized (vector) {
            for (int i = 0; i < this.messageHandlers.size(); ++i) {
                HandlerEntry he = (HandlerEntry)this.messageHandlers.elementAt(i);
                if (he.mh != mh || he.low != low || he.high != high) continue;
                this.messageHandlers.removeElementAt(i);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendKexMessage(byte[] msg) throws IOException {
        Object object = this.connectionSemaphore;
        synchronized (object) {
            if (this.connectionClosed) {
                throw (IOException)new IOException("Sorry, this connection is closed.").initCause(this.reasonClosedCause);
            }
            this.flagKexOngoing = true;
            try {
                this.tc.sendMessage(msg);
            }
            catch (IOException e) {
                this.close(e, false);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kexFinished() throws IOException {
        Object object = this.connectionSemaphore;
        synchronized (object) {
            this.flagKexOngoing = false;
            this.connectionSemaphore.notifyAll();
        }
    }

    public void forceKeyExchange(CryptoWishList cwl, DHGexParameters dhgex) throws IOException {
        this.km.initiateKEX(cwl, dhgex);
    }

    public void changeRecvCipher(BlockCipher bc, MAC mac) {
        this.tc.changeRecvCipher(bc, mac);
    }

    public void changeSendCipher(BlockCipher bc, MAC mac) {
        this.tc.changeSendCipher(bc, mac);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAsynchronousMessage(byte[] msg) throws IOException {
        Vector vector = this.asynchronousQueue;
        synchronized (vector) {
            this.asynchronousQueue.addElement(msg);
            if (this.asynchronousQueue.size() > 100) {
                throw new IOException("Error: the peer is not consuming our asynchronous replies.");
            }
            if (this.asynchronousThread == null) {
                this.asynchronousThread = new AsynchronousWorker();
                this.asynchronousThread.setDaemon(true);
                this.asynchronousThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionMonitors(Vector monitors) {
        TransportManager transportManager = this;
        synchronized (transportManager) {
            this.connectionMonitors = (Vector)monitors.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(byte[] msg) throws IOException {
        Object object = this.connectionSemaphore;
        synchronized (object) {
            while (true) {
                if (this.connectionClosed) {
                    throw (IOException)new IOException("Sorry, this connection is closed.").initCause(this.reasonClosedCause);
                }
                if (!this.flagKexOngoing) break;
                try {
                    this.connectionSemaphore.wait();
                }
                catch (InterruptedException e) {}
            }
            try {
                this.tc.sendMessage(msg);
            }
            catch (IOException e) {
                this.close(e, false);
                throw e;
            }
        }
    }

    @Deprecated
    public void receiveLoop() throws IOException {
        byte[] msg = new byte[35000];
        while (true) {
            TypesReader tr;
            int msglen = this.tc.receiveMessage(msg, 0, msg.length);
            int type = msg[0] & 0xFF;
            if (type == 2) continue;
            if (type == 4) {
                if (!log.isEnabled()) continue;
                tr = new TypesReader(msg, 0, msglen);
                tr.readByte();
                tr.readBoolean();
                StringBuffer debugMessageBuffer = new StringBuffer();
                debugMessageBuffer.append(tr.readString("UTF-8"));
                for (int i = 0; i < debugMessageBuffer.length(); ++i) {
                    char c = debugMessageBuffer.charAt(i);
                    if (c >= ' ' && c <= '~') continue;
                    debugMessageBuffer.setCharAt(i, '\ufffd');
                }
                log.log(50, "DEBUG Message from remote: '" + debugMessageBuffer.toString() + "'");
                continue;
            }
            if (type == 3) {
                throw new IOException("Peer sent UNIMPLEMENTED message, that should not happen.");
            }
            if (type == 1) {
                tr = new TypesReader(msg, 0, msglen);
                tr.readByte();
                int reason_code = tr.readUINT32();
                StringBuffer reasonBuffer = new StringBuffer();
                reasonBuffer.append(tr.readString("UTF-8"));
                if (reasonBuffer.length() > 255) {
                    reasonBuffer.setLength(255);
                    reasonBuffer.setCharAt(254, '.');
                    reasonBuffer.setCharAt(253, '.');
                    reasonBuffer.setCharAt(252, '.');
                }
                for (int i = 0; i < reasonBuffer.length(); ++i) {
                    char c = reasonBuffer.charAt(i);
                    if (c >= ' ' && c <= '~') continue;
                    reasonBuffer.setCharAt(i, '\ufffd');
                }
                throw new IOException("Peer sent DISCONNECT message (reason code " + reason_code + "): " + reasonBuffer.toString());
            }
            if (type == 20 || type == 21 || type >= 30 && type <= 49) {
                this.km.handleMessage(msg, msglen);
                continue;
            }
            MessageHandler mh = null;
            for (int i = 0; i < this.messageHandlers.size(); ++i) {
                HandlerEntry he = (HandlerEntry)this.messageHandlers.elementAt(i);
                if (he.low > type || type > he.high) continue;
                mh = he.mh;
                break;
            }
            if (mh == null) {
                throw new IOException("Unexpected SSH message (type " + type + ")");
            }
            mh.handleMessage(msg, msglen);
        }
    }

    private void notifyHandlerClose() {
        if (this.km != null) {
            try {
                this.km.handleMessage(null, 0);
            }
            catch (IOException e) {
                log.log(10, "Notify KexManager to close error: '" + e.getMessage());
            }
        }
        for (int i = 0; i < this.messageHandlers.size(); ++i) {
            HandlerEntry he = (HandlerEntry)this.messageHandlers.elementAt(i);
            try {
                he.mh.handleMessage(null, 0);
                continue;
            }
            catch (Exception ignore) {
                log.log(10, "Notify MessageHandler to close error: '" + ignore.getMessage());
            }
        }
    }

    private byte[] receivePacket(byte[] packet, int off, int len) throws IOException {
        byte[] msg = null;
        msg = this.tc.receivePacket(packet, off, len);
        if (null == msg) {
            return null;
        }
        int msglen = msg.length;
        int type = msg[0] & 0xFF;
        switch (type) {
            case 2: {
                return null;
            }
            case 4: {
                this.handleDebugPacket(msg, msglen);
                return null;
            }
            case 3: {
                throw new IOException("Peer sent UNIMPLEMENTED message, that should not happen.");
            }
            case 1: {
                this.handleDisconnectPacket(msg, msglen);
                break;
            }
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSelector(Selector sel) throws IOException {
        this.socketChannel.configureBlocking(false);
        Object object = SelectorThread.SELECTOR_LOCK;
        synchronized (object) {
            sel.wakeup();
            this.socketChannel.register(sel, 1, this);
        }
    }

    @Override
    public void handlePacket(byte[] packet) throws IOException {
        byte[] msg = null;
        int len = 0;
        boolean possibleHasPacket = true;
        try {
            for (int off = 0; off < packet.length || possibleHasPacket; off += len) {
                int writableLen = this.tc.getWritableLen();
                if (0 == writableLen) {
                    throw new IOException("The read buffer is full,doesn't have any size for write!");
                }
                len = Math.min(packet.length - off, this.tc.getWritableLen());
                msg = this.receivePacket(packet, off, len);
                if (null == msg) {
                    possibleHasPacket = false;
                    continue;
                }
                this.dispatchPacket(msg);
                possibleHasPacket = true;
            }
        }
        catch (IOException e) {
            this.close(e, false);
            throw e;
        }
    }

    private void dispatchPacket(byte[] msg) throws IOException {
        int msglen = msg.length;
        int type = msg[0] & 0xFF;
        if (type == 20 || type == 21 || type >= 30 && type <= 49) {
            this.km.handleMessage(msg, msglen);
            return;
        }
        MessageHandler mh = null;
        for (int i = 0; i < this.messageHandlers.size(); ++i) {
            HandlerEntry he = (HandlerEntry)this.messageHandlers.elementAt(i);
            if (he.low > type || type > he.high) continue;
            mh = he.mh;
            break;
        }
        if (mh == null) {
            throw new IOException("Unexpected SSH message (type " + type + ")");
        }
        mh.handleMessage(msg, msglen);
    }

    private void handleDebugPacket(byte[] msg, int msglen) throws IOException {
        TypesReader tr = new TypesReader(msg, 0, msglen);
        tr.readByte();
        tr.readBoolean();
        StringBuffer debugMessageBuffer = new StringBuffer();
        debugMessageBuffer.append(tr.readString("UTF-8"));
        for (int i = 0; i < debugMessageBuffer.length(); ++i) {
            char c = debugMessageBuffer.charAt(i);
            if (c >= ' ' && c <= '~') continue;
            debugMessageBuffer.setCharAt(i, '\ufffd');
        }
        log.log(50, "DEBUG Message from remote: '" + debugMessageBuffer.toString() + "'");
    }

    private void handleDisconnectPacket(byte[] msg, int msglen) throws IOException {
        TypesReader tr = new TypesReader(msg, 0, msglen);
        tr.readByte();
        int reason_code = tr.readUINT32();
        StringBuffer reasonBuffer = new StringBuffer();
        reasonBuffer.append(tr.readString("UTF-8"));
        if (reasonBuffer.length() > 255) {
            reasonBuffer.setLength(255);
            reasonBuffer.setCharAt(254, '.');
            reasonBuffer.setCharAt(253, '.');
            reasonBuffer.setCharAt(252, '.');
        }
        for (int i = 0; i < reasonBuffer.length(); ++i) {
            char c = reasonBuffer.charAt(i);
            if (c >= ' ' && c <= '~') continue;
            reasonBuffer.setCharAt(i, '\ufffd');
        }
        throw new IOException("Peer sent DISCONNECT message (reason code " + reason_code + "): " + reasonBuffer.toString());
    }

    private String getConnAddressInfo() {
        String addressInfo = "";
        if (null != this.sock) {
            addressInfo = "localAddress = " + this.sock.getLocalAddress().getHostAddress() + ":" + this.sock.getLocalPort() + "; the remote serverAddress = " + this.hostname + ":" + this.port;
        }
        return addressInfo;
    }

    class AsynchronousWorker
    extends Thread {
        AsynchronousWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                byte[] msg = null;
                Vector vector = TransportManager.this.asynchronousQueue;
                synchronized (vector) {
                    if (TransportManager.this.asynchronousQueue.size() == 0) {
                        try {
                            TransportManager.this.asynchronousQueue.wait(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (TransportManager.this.asynchronousQueue.size() == 0) {
                            TransportManager.this.asynchronousThread = null;
                            return;
                        }
                    }
                    msg = (byte[])TransportManager.this.asynchronousQueue.remove(0);
                }
                try {
                    TransportManager.this.sendMessage(msg);
                }
                catch (IOException e) {
                    return;
                }
            }
        }
    }

    class HandlerEntry {
        MessageHandler mh;
        int low;
        int high;

        HandlerEntry() {
        }
    }
}

