/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.nio;

import com.trilead.ssh2.log.Logger;
import com.trilead.ssh2.nio.IPacketHandler;
import com.trilead.ssh2.transport.TransportManager;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;

public class SelectorThread
extends Thread {
    public static final Object SELECTOR_LOCK = new Object();
    private static SelectorThread selThread = new SelectorThread();
    private static final Logger log = Logger.getLogger(SelectorThread.class);
    private Selector selector;
    private ByteBuffer buffer = ByteBuffer.allocate(35005);

    private SelectorThread() {
        this.setName(SelectorThread.class.getName());
        try {
            this.selector = Selector.open();
            this.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to open a selector.", e);
        }
    }

    public static Selector getSelector() throws IOException {
        return SelectorThread.selThread.selector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                block9: while (true) {
                    Object object = SELECTOR_LOCK;
                    synchronized (object) {
                    }
                    this.selector.select();
                    Iterator<SelectionKey> selectedKeys = this.selector.selectedKeys().iterator();
                    while (true) {
                        if (!selectedKeys.hasNext()) continue block9;
                        SelectionKey key = selectedKeys.next();
                        selectedKeys.remove();
                        try {
                            if (!key.isValid() || !key.isReadable()) continue;
                            this.read(key);
                        }
                        catch (CancelledKeyException e) {
                            log.log(50, "when judge SelectionKey isReadable,the connection is closed ,so  throw a CancelledKeyException ,it should be ignored.");
                            ((TransportManager)key.attachment()).close(null, false);
                        }
                        catch (Exception e) {
                            log.log(10, "when read the SelectionKey \u00a3\u00acthrow an Exception \u00a3\u00ba", e);
                            ((TransportManager)key.attachment()).close(null, false);
                        }
                    }
                    break;
                }
            }
            catch (Exception e) {
                log.log(10, "Receive thread error in SelectorThread.run(): ", e);
                continue;
            }
            break;
        }
    }

    private void read(SelectionKey key) throws IOException {
        IPacketHandler handler = (IPacketHandler)key.attachment();
        try {
            while (true) {
                byte[] msg;
                if (null == (msg = this.getSocketMsg(key))) {
                    return;
                }
                handler.handlePacket(msg);
            }
        }
        catch (IOException e) {
            log.log(10, "Receive thread error in SelectorThread.read(): ", e);
            ((TransportManager)key.attachment()).close(null, false);
            try {
                key.channel().close();
            }
            catch (IOException e1) {
                log.log(10, "Close socketChannel has error:", e);
            }
            return;
        }
    }

    private byte[] getSocketMsg(SelectionKey key) throws IOException {
        SocketChannel socketChannel = (SocketChannel)key.channel();
        int numRead = socketChannel.read(this.buffer);
        if (0 == numRead) {
            return null;
        }
        if (-1 == numRead) {
            throw new IOException("Receive thread: SocketChannel EOF reached ");
        }
        this.buffer.flip();
        byte[] msg = new byte[this.buffer.remaining()];
        this.buffer.get(msg);
        this.buffer.clear();
        return msg;
    }
}

