/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.crypto.cipher;

import com.trilead.ssh2.crypto.cipher.BlockCipher;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class CipherOutputStream {
    private static final int BUFF_SIZE = 2048;
    private BlockCipher currentCipher;
    private byte[] blockBuffer;
    private int blockSize;
    private int hasWriteBlockSize;
    private SocketChannel socketChannel;
    private ByteBuffer outBuffer = ByteBuffer.allocate(2048);

    public CipherOutputStream(BlockCipher tc, SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
        this.changeCipher(tc);
    }

    private void internalWrite(byte[] src, int off, int len) throws IOException {
        this.outBuffer.put(src, off, len);
    }

    private void internalWrite(int src) throws IOException {
        this.outBuffer.put((byte)src);
    }

    public void flush() throws IOException {
        if (this.hasWriteBlockSize != 0) {
            throw new IOException("FATAL: cannot flush since crypto blockBuffer is not aligned.");
        }
        this.outBuffer.flip();
        while (this.outBuffer.hasRemaining()) {
            this.socketChannel.write(this.outBuffer);
        }
        this.outBuffer.clear();
    }

    public void changeCipher(BlockCipher bc) {
        this.currentCipher = bc;
        this.blockSize = bc.getBlockSize();
        this.blockBuffer = new byte[this.blockSize];
        this.hasWriteBlockSize = 0;
    }

    private void writeBlock() throws IOException {
        byte[] transBuffer = new byte[this.blockBuffer.length];
        try {
            this.currentCipher.transformBlock(this.blockBuffer, 0, transBuffer, 0);
        }
        catch (Exception e) {
            throw new IOException("Error while encrypt block.", e);
        }
        this.internalWrite(transBuffer, 0, this.blockBuffer.length);
        this.hasWriteBlockSize = 0;
    }

    public void write(byte[] src, int off, int len) throws IOException {
        int copySize;
        this.adjustBufferSize(len);
        int writeOff = off;
        for (int writeLen = len; writeLen > 0; writeLen -= copySize) {
            copySize = Math.min(this.blockSize - this.hasWriteBlockSize, writeLen);
            System.arraycopy(src, writeOff, this.blockBuffer, this.hasWriteBlockSize, copySize);
            this.hasWriteBlockSize += copySize;
            writeOff += copySize;
            if (this.hasWriteBlockSize != this.blockSize) continue;
            this.writeBlock();
        }
    }

    public void write(byte[] src) throws IOException {
        this.write(src, 0, src.length);
    }

    public void write(int src) throws IOException {
        this.adjustBufferSize(1);
        this.blockBuffer[this.hasWriteBlockSize++] = (byte)src;
        if (this.hasWriteBlockSize >= this.blockSize) {
            this.writeBlock();
        }
    }

    public void writePlain(int src) throws IOException {
        this.adjustBufferSize(1);
        if (this.hasWriteBlockSize != 0) {
            throw new IOException("Cannot write plain since crypto blockBuffer is not aligned.");
        }
        this.internalWrite(src);
    }

    public void writePlain(byte[] src, int off, int len) throws IOException {
        this.adjustBufferSize(len);
        if (this.hasWriteBlockSize != 0) {
            throw new IOException("Cannot write plain since crypto buffer is not aligned.");
        }
        this.internalWrite(src, off, len);
    }

    public void writePlain(byte[] src) throws IOException {
        this.writePlain(src, 0, src.length);
    }

    private void adjustBufferSize(int addSize) {
        if (this.outBuffer.remaining() < addSize + this.hasWriteBlockSize) {
            ByteBuffer newBuffer = ByteBuffer.allocate(this.outBuffer.capacity() + addSize);
            this.outBuffer.flip();
            newBuffer.put(this.outBuffer);
            this.outBuffer = newBuffer;
        }
    }
}

