/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.crypto.cipher;

import com.trilead.ssh2.crypto.cipher.BlockCipher;
import java.io.IOException;
import java.nio.ByteBuffer;

public class CipherInputStream {
    private static final int OFFSET = 255;
    private BlockCipher currentCipher;
    private byte[] blockBuffer;
    private int blockSize;
    private int hasReadBlockSize;
    private ByteBuffer inputBuffer = ByteBuffer.allocate(35005);

    public CipherInputStream(BlockCipher tc) {
        this.inputBuffer.flip();
        this.changeCipher(tc, 0);
    }

    public void appendData(byte[] data) throws IOException {
        this.appendData(data, 0, data.length);
    }

    public void appendData(byte[] data, int off, int len) throws IOException {
        if (0 == len) {
            return;
        }
        this.inputBuffer.compact();
        this.inputBuffer.put(data, off, len);
        this.inputBuffer.flip();
    }

    public void changeCipher(BlockCipher bc, int macSize) {
        this.currentCipher = bc;
        this.blockSize = bc.getBlockSize();
        this.blockBuffer = new byte[this.blockSize];
        this.hasReadBlockSize = this.blockSize;
        int maxPacketSize = 35005 + macSize;
        if (this.inputBuffer.capacity() < maxPacketSize) {
            this.inputBuffer = ByteBuffer.allocate(maxPacketSize);
            this.inputBuffer.flip();
        }
    }

    private void getBlock() throws IOException {
        byte[] transBuffer = new byte[this.blockBuffer.length];
        this.inputBuffer.get(transBuffer, 0, transBuffer.length);
        try {
            this.currentCipher.transformBlock(transBuffer, 0, this.blockBuffer, 0);
        }
        catch (Exception e) {
            throw new IOException("Error while decrypting block.", e);
        }
        this.hasReadBlockSize = 0;
    }

    public void read(byte[] dst) throws IOException {
        this.read(dst, 0, dst.length);
    }

    public void read(byte[] dst, int off, int len) throws IOException {
        int copySize;
        int readOff = off;
        for (int readLen = len; readLen > 0; readLen -= copySize) {
            if (this.hasReadBlockSize == this.blockSize) {
                this.getBlock();
            }
            copySize = Math.min(this.blockSize - this.hasReadBlockSize, readLen);
            System.arraycopy(this.blockBuffer, this.hasReadBlockSize, dst, readOff, copySize);
            this.hasReadBlockSize += copySize;
            readOff += copySize;
        }
    }

    public int read() throws IOException {
        if (this.hasReadBlockSize == this.blockSize) {
            this.getBlock();
        }
        return this.blockBuffer[this.hasReadBlockSize++] & 0xFF;
    }

    public void readPlain(byte[] dst, int off, int len) throws IOException {
        if (this.hasReadBlockSize != this.blockSize) {
            throw new IOException("Cannot readPlain " + len + " bytes,because  buffer is not aligned");
        }
        this.inputBuffer.get(dst, off, len);
    }

    public boolean canReadNext(int length) {
        return length <= this.inputBuffer.remaining() + (this.blockSize - this.hasReadBlockSize);
    }

    public boolean canReadBlock(int length) {
        return length % this.blockSize == 0;
    }

    public void readPlain(byte[] dst) throws IOException {
        this.readPlain(dst, 0, dst.length);
    }

    public int getWritableLen() {
        return this.inputBuffer.capacity() - this.inputBuffer.limit();
    }
}

