/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.channel;

import com.trilead.ssh2.channel.ChannelInputStream;
import com.trilead.ssh2.channel.ChannelManager;
import com.trilead.ssh2.channel.ChannelOutputStream;
import com.trilead.ssh2.channel.ISessionHandler;
import java.io.IOException;

public class Channel {
    static final int STATE_OPENING = 1;
    static final int STATE_OPEN = 2;
    static final int STATE_CLOSED = 4;
    static final int CHANNEL_BUFFER_SIZE = 30000;
    final ChannelManager cm;
    final ChannelOutputStream stdinStream;
    final ChannelInputStream stdoutStream;
    final ChannelInputStream stderrStream;
    int localID = -1;
    int remoteID = -1;
    final Object channelSendLock = new Object();
    boolean closeMessageSent = false;
    final byte[] msgWindowAdjust = new byte[9];
    int state = 1;
    boolean closeMessageRecv = false;
    int successCounter = 0;
    int failedCounter = 0;
    int localWindow = 0;
    long remoteWindow = 0L;
    int localMaxPacketSize = -1;
    int remoteMaxPacketSize = -1;
    final byte[] stdoutBuffer = new byte[30000];
    final byte[] stderrBuffer = new byte[30000];
    int stdoutReadpos = 0;
    int stdoutWritepos = 0;
    int stderrReadpos = 0;
    int stderrWritepos = 0;
    boolean EOF = false;
    Integer exit_status;
    String exit_signal;
    String hexX11FakeCookie;
    private final Object reasonClosedLock = new Object();
    private String reasonClosed = null;
    private ISessionHandler handler;
    private StringBuilder dataBuffer = new StringBuilder();
    private StringBuilder errBuffer = new StringBuilder();

    public Channel(ChannelManager cm) {
        this.cm = cm;
        this.localWindow = 30000;
        this.localMaxPacketSize = 33976;
        this.stdinStream = new ChannelOutputStream(this);
        this.stdoutStream = new ChannelInputStream(this, false);
        this.stderrStream = new ChannelInputStream(this, true);
    }

    public ChannelInputStream getStderrStream() {
        return this.stderrStream;
    }

    public ChannelOutputStream getStdinStream() {
        return this.stdinStream;
    }

    public ChannelInputStream getStdoutStream() {
        return this.stdoutStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExitSignal() {
        Channel channel = this;
        synchronized (channel) {
            return this.exit_signal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getExitStatus() {
        Channel channel = this;
        synchronized (channel) {
            return this.exit_status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getReasonClosed() {
        Object object = this.reasonClosedLock;
        synchronized (object) {
            return this.reasonClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReasonClosed(String reasonClosed) {
        Object object = this.reasonClosedLock;
        synchronized (object) {
            if (this.reasonClosed == null) {
                this.reasonClosed = reasonClosed;
            }
        }
    }

    public void setChannelHandler(ISessionHandler handler) {
        this.handler = handler;
    }

    public ISessionHandler getChannelHandler() {
        return this.handler;
    }

    public void sendMessage(byte[] msg) throws IOException {
        this.stdinStream.write(msg);
    }

    public String getData() {
        String data = this.dataBuffer.toString();
        this.dataBuffer.delete(0, this.dataBuffer.length());
        return data;
    }

    public String getError() {
        String error = this.errBuffer.toString();
        this.errBuffer.delete(0, this.errBuffer.length());
        return error;
    }

    public void appendData(String data) {
        this.dataBuffer.append(data);
    }

    public void appendError(String error) {
        this.errBuffer.append(error);
    }
}

