/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.traceroute;

import com.huawei.uflight.traceroute.ITraceReceiver;
import com.huawei.uflight.traceroute.TraceInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceRouterTool {
    public static final String MAXHOPS = "maxhop";
    public static final String WAIT_TIME = "waitTime";
    private static final int TRACE_ROUTER_TYPE_WIN = 1;
    private static final int TRACE_ROUTER_TYPE_UNIX = 2;
    private static int traceType = 1;
    private static final String WINDOWS_SYS = "Windows";
    private static final String WIN_CMD = "tracert -h %s -w %s %s";
    private static final String UNIX_CMD = "traceroute -m %s -w %s -n %s";
    private static final String SN_MATCH = "^\\s+\\d+";
    private static final String IP_MATCH = "\\d+\\.\\d+\\.\\d+\\.\\d+";
    private static final Logger LOG = LoggerFactory.getLogger(TraceRouterTool.class);
    private static final Pattern SN_PATTERN = Pattern.compile("^\\s+\\d+");
    private static final String HOST_MATCH;
    private static final Pattern IP_PATTERN;

    private TraceRouterTool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exeTrace(String host, ITraceReceiver receiver, Map<String, Object> paraMaps) {
        int maxHops = (Integer)paraMaps.get(MAXHOPS);
        int waitTime = (Integer)paraMaps.get(WAIT_TIME);
        BufferedReader br = null;
        try {
            String cmd = null;
            cmd = traceType == 1 ? String.format(WIN_CMD, maxHops, waitTime * 1000, host) : String.format(UNIX_CMD, maxHops, waitTime, host);
            Process pro = Runtime.getRuntime().exec(cmd);
            br = new BufferedReader(new InputStreamReader(pro.getInputStream()));
            String msg = null;
            msg = br.readLine();
            while (msg != null) {
                if (!msg.trim().isEmpty()) {
                    TraceRouterTool.traceParse(msg, receiver);
                }
                msg = br.readLine();
            }
        }
        catch (Exception e) {
            LOG.error("trace fail" + e);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                LOG.error("trace stream close fail" + e);
            }
        }
        receiver.finished();
    }

    public static void trace(String host, ITraceReceiver receiver, Map<String, Object> ... paraMaps) {
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put(MAXHOPS, 30);
        para.put(WAIT_TIME, 1);
        if (0 != paraMaps.length) {
            para.put(MAXHOPS, paraMaps[0].get(MAXHOPS));
            para.put(WAIT_TIME, paraMaps[0].get(WAIT_TIME));
        }
        TraceRouterTool.exeTrace(host, receiver, para);
    }

    private static void traceParse(String traceStr, ITraceReceiver receiver) {
        Matcher snMatcher = SN_PATTERN.matcher(traceStr);
        if (!snMatcher.find()) {
            return;
        }
        TraceInfo info = new TraceInfo();
        info.setTraceSN(snMatcher.group().trim());
        String host = TraceRouterTool.findHost(traceStr);
        if (null == host) {
            receiver.receiverData(info);
            return;
        }
        info.setHost(host);
        String traceTimes = traceStr.replaceFirst(SN_MATCH, "").replaceFirst(HOST_MATCH, "").trim();
        info.setTraceTimes(traceTimes);
        receiver.receiverData(info);
    }

    private static String findHost(String lines) {
        Matcher matchIP = IP_PATTERN.matcher(lines);
        if (matchIP.find()) {
            return matchIP.group();
        }
        return null;
    }

    static {
        String osName = System.getProperties().getProperty("os.name");
        if (osName.contains(WINDOWS_SYS)) {
            traceType = 1;
            HOST_MATCH = IP_MATCH;
        } else {
            traceType = 2;
            HOST_MATCH = "\\d+\\.\\d+\\.\\d+\\.\\d+ \\(.*\\)";
        }
        IP_PATTERN = Pattern.compile(HOST_MATCH);
    }
}

