/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.ping.snmp;

import com.huawei.uflight.ping.snmp.SnmpPara;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class Snmp4jPing {
    private static final int TIMEOUT = 1000;
    private static final int RETRY_CNTS = 3;
    private static final Logger log = LoggerFactory.getLogger(Snmp4jPing.class);

    public Map<String, Boolean> ping(SnmpPara[] snmpParaArray) {
        Map<String, Boolean> result = null;
        try {
            result = this.pings(snmpParaArray);
        }
        catch (Exception e) {
            log.debug("ping fail" + e);
        }
        return result;
    }

    private Map<String, Boolean> pings(SnmpPara[] snmpParaArray) throws Exception {
        final HashMap<String, Boolean> result = new HashMap<String, Boolean>(snmpParaArray.length);
        for (SnmpPara key : snmpParaArray) {
            result.put(key.getStringPara("TargetHost"), false);
        }
        final CountDownLatch doneSignal = new CountDownLatch(snmpParaArray.length);
        ResponseListener listener = new ResponseListener(){

            public void onResponse(ResponseEvent event) {
                PDU response = event.getResponse();
                if (response != null) {
                    IpAddress adress = (IpAddress)event.getPeerAddress();
                    result.put(adress.getInetAddress().getHostAddress(), true);
                }
                doneSignal.countDown();
            }
        };
        DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
        transport.listen();
        Snmp snmp = new Snmp((TransportMapping)transport);
        PDU pdu = new PDU();
        pdu.add(new VariableBinding(new OID("1.3.6.1.2.1.1.3.0")));
        pdu.setType(-96);
        for (SnmpPara snmpPara : snmpParaArray) {
            CommunityTarget target = new CommunityTarget();
            target.setCommunity(new OctetString(snmpPara.getStringPara("ReadCommunity")));
            Address targetAddress = GenericAddress.parse((String)("udp:" + snmpPara.getStringPara("TargetHost") + "/" + snmpPara.getIntPara("TargetPort", new int[0])));
            target.setAddress(targetAddress);
            target.setVersion(0);
            target.setTimeout((long)snmpPara.getIntPara("TimeOut", 1000));
            target.setRetries(snmpPara.getIntPara("RetryCnts", 3));
            snmp.send(pdu, (Target)target, null, listener);
        }
        doneSignal.await();
        transport.close();
        snmp.close();
        return result;
    }
}

