/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.ping.icmp;

import com.huawei.commextend.frameutil.PingUtil;
import com.huawei.uflight.ping.IpingReceiver;
import com.huawei.uflight.ping.icmp.CPing;
import com.huawei.uflight.ping.icmp.IcmpPing;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcmpPingImp
implements IcmpPing {
    private CPing cPing = new CPing();
    private static Logger log;

    @Override
    public void asyncPing(final List<String[]> ipAdressList, final int timeOut, final int tryNum, final int packageWaitTime, final IpingReceiver receiver) {
        if (null == ipAdressList || ipAdressList.isEmpty()) {
            log.error("ipAdressList is null");
            return;
        }
        Runnable pingRunnable = new Runnable(){

            @Override
            public void run() {
                for (String[] ipAdress : ipAdressList) {
                    Map<String, Boolean> result = IcmpPingImp.this.ping(ipAdress, timeOut, tryNum);
                    receiver.receiverData(result);
                    try {
                        Thread.sleep(packageWaitTime);
                    }
                    catch (InterruptedException e) {
                        log.error("error", (Throwable)e);
                    }
                }
                receiver.finished();
            }
        };
        Thread t = new Thread(pingRunnable, "IcmpPingImpThread");
        t.start();
    }

    @Override
    public Map<String, Boolean> ping(String[] ipAdress, int timeOut, int tryNum) {
        int sucessNum;
        if (ipAdress == null || ipAdress.length == 0) {
            log.error("ipAdress is null");
            return null;
        }
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(ipAdress.length);
        for (String key : ipAdress) {
            if (key == null) {
                log.error("ipAdress has null elemnet, must return");
                return result;
            }
            result.put(key, false);
        }
        for (int i = 0; i < tryNum && (sucessNum = this.ping(ipAdress, timeOut, result)) < ipAdress.length; ++i) {
        }
        return result;
    }

    private int ping(String[] ipAdress, int timeOut, Map<String, Boolean> result) {
        return this.pingWithMc(ipAdress, timeOut, result);
    }

    private int pingWithJni(String[] ipAdress, int timeOut, Map<String, Boolean> result) {
        HashSet<String> reachAbles = new HashSet<String>();
        log.info("start cping, ping size is " + ipAdress.length + ", time out is " + timeOut);
        int retcode = this.cPing.execute(ipAdress, reachAbles, timeOut + this.timeOutIncrement(ipAdress.length));
        log.info("cping retcode is =" + retcode + " reachAbles is " + reachAbles.size());
        for (String sucIP : reachAbles) {
            result.put(sucIP, true);
        }
        return reachAbles.size();
    }

    private int pingWithMc(String[] ipAdress, int timeOut, Map<String, Boolean> result) {
        log.info("start pingWithMc,  size is " + ipAdress.length + ", time out is " + timeOut);
        List reachAbles = PingUtil.ping((String[])ipAdress, (int)(timeOut + this.timeOutIncrement(ipAdress.length)));
        log.info(" reachAbles is " + reachAbles.size());
        for (String sucIP : reachAbles) {
            result.put(sucIP, true);
        }
        return reachAbles.size();
    }

    private boolean isLinuxOS() {
        String osName = System.getProperties().getProperty("os.name").toLowerCase();
        return osName.contains("linux");
    }

    private int timeOutIncrement(int pingCount) {
        int increment = 500 + pingCount / 5000 * 1000;
        return increment;
    }

    static {
        System.loadLibrary("ACE");
        System.loadLibrary("ICMPPing");
        log = LoggerFactory.getLogger(IcmpPingImp.class);
    }
}

