/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.extension.support;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSGiUtils {
    private Logger logger = LoggerFactory.getLogger(OSGiUtils.class);
    private static final OSGiUtils SINGLETON = new OSGiUtils();
    private static final int LENGTH = 3;
    private static final int INDEX_0 = 0;
    private static final int INDEX_1 = 1;
    private static final int INDEX_2 = 2;
    private ServiceTracker pkgAdmTracker;
    private boolean hasInit;

    private OSGiUtils() {
    }

    public static OSGiUtils getInstance() {
        return SINGLETON;
    }

    public void init(BundleContext context) {
        if (!this.hasInit) {
            if (context == null) {
                throw new IllegalArgumentException("The ExtensionActivator is not activated.");
            }
            this.pkgAdmTracker = new ServiceTracker(context, PackageAdmin.class.getName(), null);
            this.pkgAdmTracker.open();
            this.hasInit = true;
        }
    }

    public void closeServices() {
        if (this.pkgAdmTracker != null) {
            this.pkgAdmTracker.close();
            this.pkgAdmTracker = null;
        }
        this.hasInit = false;
    }

    public PackageAdmin getPackageAdmin() {
        if (this.pkgAdmTracker == null) {
            this.logger.info("The PackageAdmin service is null.");
            return null;
        }
        return (PackageAdmin)this.pkgAdmTracker.getService();
    }

    public boolean isFragment(Bundle bundle) {
        PackageAdmin packageAdmin = this.getPackageAdmin();
        if (packageAdmin == null) {
            return false;
        }
        return (packageAdmin.getBundleType(bundle) & 1) > 0;
    }

    public Bundle getBundle(String bundleName) {
        PackageAdmin packageAdmin = this.getPackageAdmin();
        if (packageAdmin == null) {
            return null;
        }
        Bundle[] bundles = packageAdmin.getBundles(bundleName, null);
        if (bundles == null) {
            return null;
        }
        for (int i = 0; i < bundles.length; ++i) {
            if ((bundles[i].getState() & 3) != 0) continue;
            return bundles[i];
        }
        return null;
    }

    public Bundle getBundle(String bundleName, String bundleVersion) {
        PackageAdmin packageAdmin = this.getPackageAdmin();
        if (packageAdmin == null) {
            return null;
        }
        Bundle[] bundles = packageAdmin.getBundles(bundleName, OSGiUtils.version2VersionRange(bundleVersion));
        if (bundles == null) {
            return null;
        }
        for (int i = 0; i < bundles.length; ++i) {
            if ((bundles[i].getState() & 3) != 0) continue;
            return bundles[i];
        }
        return null;
    }

    public static String version2VersionRange(String version) {
        if (version == null) {
            return null;
        }
        String separator = ".";
        String[] verList = version.split("\\.");
        if (verList.length < 3) {
            return null;
        }
        int micro = 0;
        try {
            micro = Integer.parseInt(verList[2]) + 1;
        }
        catch (NumberFormatException ex) {
            return null;
        }
        return "[" + verList[0] + "." + verList[1] + "." + verList[2] + ", " + verList[0] + "." + verList[1] + "." + micro + ")";
    }

    public Class<?> loadClass(String bundleId, String bundleVersion, String name) throws ClassNotFoundException {
        Bundle bundle = this.getBundle(bundleId, bundleVersion);
        if (bundle == null) {
            throw new IllegalStateException("Bundle is uninstalled:bundleId=" + bundleId + ", bundleVersion=" + bundleVersion);
        }
        return bundle.loadClass(name);
    }
}

