/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.extension.support;

import com.huawei.uflight.extension.ExtensionPoint;
import com.huawei.uflight.extension.internal.Extension;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AppXMLFile {
    private static final String ID = "id";
    private static final String VERSION = "version";
    public static final String POINT = "point";
    public static final String EXTENSION_NODE = "extension";
    private Document document = null;
    private String rootNodeName = null;
    private String pluginRunPath;
    private static final Logger logger = LoggerFactory.getLogger(AppXMLFile.class);

    public AppXMLFile(String rootNodeName) {
        this.rootNodeName = rootNodeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromFile(InputStream stream, String filePath) throws Exception {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.document = db.parse(stream);
            this.pluginRunPath = filePath;
            if (this.document != null) {
                this.document.normalize();
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                    stream = null;
                }
                catch (Exception ex) {
                    logger.error("loadFromFile fail", (Throwable)ex);
                }
            }
        }
    }

    public List<ExtensionPoint> getExtensionPoints() {
        ArrayList<ExtensionPoint> pointList;
        NodeList nodeList = this.document.getElementsByTagName(EXTENSION_NODE);
        if (nodeList.getLength() > 0) {
            pointList = new ArrayList<ExtensionPoint>();
            HashMap<String, Integer> pointMap = new HashMap<String, Integer>();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                ExtensionPoint point;
                Node node = nodeList.item(i);
                String pointName = ((Element)node).getAttribute(POINT);
                if (pointName != null && !pointName.isEmpty()) {
                    point = null;
                    Integer pointIndex = (Integer)pointMap.get(pointName);
                    if (pointIndex == null) {
                        point = new ExtensionPoint(pointName);
                        pointList.add(point);
                        pointMap.put(pointName, pointList.size() - 1);
                    } else {
                        point = (ExtensionPoint)pointList.get(pointIndex);
                    }
                } else {
                    throw new IllegalArgumentException("Can not get Point attribute of Extension element.");
                }
                Extension extension = new Extension(this.getId(), (Element)node);
                extension.setPluginRunPath(this.pluginRunPath);
                extension.setExtendPointId(pointName);
                extension.setPluginVersion(this.getVersion());
                point.addExtension(extension);
            }
        } else {
            throw new IllegalArgumentException("Can not get Extension element. Path:" + this.pluginRunPath);
        }
        return pointList;
    }

    public String getId() {
        return this.getAttribute(ID);
    }

    public String getVersion() {
        return this.getAttribute(VERSION);
    }

    public String getAttribute(String name) {
        if (this.document.getElementsByTagName(this.rootNodeName) != null) {
            Element proEle = null;
            proEle = (Element)this.document.getElementsByTagName(this.rootNodeName).item(0);
            if (proEle != null) {
                return proEle.getAttribute(name);
            }
        }
        return null;
    }

    public Document getDocument() {
        return this.document;
    }

    public String getRootNodeName() {
        return this.rootNodeName;
    }
}

