/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.extension.internal.registry;

import com.huawei.uflight.extension.ExtensionPoint;
import com.huawei.uflight.extension.IExtension;
import com.huawei.uflight.extension.IExtensionListener;
import com.huawei.uflight.extension.IExtensionRegistry;
import com.huawei.uflight.extension.internal.registry.ExtensionBundleListener;
import com.huawei.uflight.extension.support.OSGiUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionRegistrySupport
implements IExtensionRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionRegistrySupport.class);
    private final ConcurrentMap<String, ExtensionPoint> pointMap = new ConcurrentHashMap<String, ExtensionPoint>();
    private final ExtensionBundleListener bundleListener = new ExtensionBundleListener(this.pointMap);
    private boolean running = false;

    public synchronized void start(BundleContext bundleContext) {
        if (this.running) {
            logger.info("ExtensionRegistrySupport is already started.");
        } else {
            bundleContext.addBundleListener((BundleListener)this.bundleListener);
            this.bundleListener.processBundles(bundleContext.getBundles());
            logger.info("Finished starting ExtensionRegistrySupport.");
            this.running = true;
        }
    }

    public synchronized void stop(BundleContext bundleContext) {
        if (this.running) {
            bundleContext.removeBundleListener((BundleListener)this.bundleListener);
            this.pointMap.clear();
            this.bundleListener.clear();
            logger.info("Finished stopping ExtensionRegistrySupport.");
            this.running = false;
        } else {
            logger.info("ExtensionRegistrySupport is already stopped.");
        }
    }

    @Override
    public Collection<IExtension> getExtensions(String point) {
        ExtensionPoint ept = this.getExtensionPoint(point);
        if (ept != null) {
            return ept.getExtensions();
        }
        logger.info("Can't find extensionPoint point = " + point);
        return new ArrayList<IExtension>(0);
    }

    @Override
    public Collection<IExtension> getExtensions(String pluginId, String pluginVersion, String point) {
        ExtensionPoint ept = this.getExtensionPoint(point);
        if (ept != null) {
            return ept.getExtension(pluginId, pluginVersion);
        }
        return new ArrayList<IExtension>(0);
    }

    @Override
    public ExtensionPoint getExtensionPoint(String point) {
        ExtensionPoint ept = (ExtensionPoint)this.pointMap.get(point);
        if (ept == null) {
            logger.info("Can't find extensionPoint point = " + point);
        }
        return ept;
    }

    private <T> Collection<T> convertXmlObject(Collection<IExtension> exts, Class<T> objectClass) {
        ArrayList<T> result = new ArrayList<T>();
        for (IExtension oneExt : exts) {
            T obj = oneExt.getExtensionObject(objectClass);
            if (obj == null) continue;
            result.add(obj);
        }
        return result;
    }

    @Override
    public <T> Collection<T> getExtensionObjects(String point, Class<T> objectClass) {
        Collection<IExtension> exts = this.getExtensions(point);
        return this.convertXmlObject(exts, objectClass);
    }

    @Override
    public <T> Collection<T> getExtensionObjects(String pluginId, String pluginVersion, String point, Class<T> objectClass) {
        Collection<IExtension> exts = this.getExtensions(pluginId, pluginVersion, point);
        return this.convertXmlObject(exts, objectClass);
    }

    @Override
    public void addExtensionListener(IExtensionListener listener) {
        this.bundleListener.addExtensionListener(listener);
    }

    @Override
    public void removeExtensionListener(IExtensionListener listener) {
        this.bundleListener.removeExtensionListener(listener);
    }

    @Override
    public Class<?> loadClass(String pluginId, String pluginVersion, String className) throws ClassNotFoundException {
        return OSGiUtils.getInstance().loadClass(pluginId, pluginVersion, className);
    }
}

