/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.extension.internal.registry;

import com.huawei.uflight.extension.ExtensionDelta;
import com.huawei.uflight.extension.ExtensionEvent;
import com.huawei.uflight.extension.ExtensionPoint;
import com.huawei.uflight.extension.IExtension;
import com.huawei.uflight.extension.IExtensionListener;
import com.huawei.uflight.extension.internal.registry.PluginXMLFile;
import com.huawei.uflight.extension.support.OSGiUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.SynchronousBundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionBundleListener
implements SynchronousBundleListener {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionBundleListener.class);
    private final ConcurrentMap<String, ExtensionPoint> pointMap;
    private final CopyOnWriteArrayList<IExtensionListener> listenerList;

    public ExtensionBundleListener(ConcurrentMap<String, ExtensionPoint> pointMap) {
        this.pointMap = pointMap;
        this.listenerList = new CopyOnWriteArrayList();
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 32: {
                this.addBundle(event.getBundle());
                break;
            }
            case 64: {
                this.removeBundle(event.getBundle());
                break;
            }
        }
    }

    private boolean isBundleResolved(Bundle bundle) {
        return (bundle.getState() & 0x3C) != 0;
    }

    public void processBundles(Bundle[] bundles) {
        for (int i = 0; i < bundles.length; ++i) {
            Bundle bundle = bundles[i];
            if (this.isBundleResolved(bundle)) {
                this.addBundle(bundle);
                continue;
            }
            this.removeBundle(bundle);
        }
    }

    private String getExtensionFileName() {
        return "META-INF/uflight/extension.xml";
    }

    private void addBundle(Bundle bundle) {
        BufferedInputStream inputStream;
        if (OSGiUtils.getInstance().isFragment(bundle)) {
            logger.info("The bundle is fragment:" + bundle + " Ignore it");
            return;
        }
        String fileName = this.getExtensionFileName();
        URL extensionURL = bundle.getEntry(fileName);
        if (extensionURL == null) {
            return;
        }
        try {
            inputStream = new BufferedInputStream(extensionURL.openStream());
        }
        catch (IOException ex) {
            logger.error("bundle is " + bundle.getSymbolicName(), (Throwable)ex);
            inputStream = null;
        }
        if (inputStream == null) {
            logger.info("The inputStream is null:" + extensionURL);
            return;
        }
        try {
            logger.info("Start to parse the bundle:" + bundle);
            PluginXMLFile xmlFile = new PluginXMLFile(bundle.getSymbolicName(), bundle.getVersion().toString());
            xmlFile.loadFromFile(inputStream, fileName);
            List<ExtensionPoint> pointList = xmlFile.getExtensionPoints();
            for (ExtensionPoint point : pointList) {
                logger.info("registerExtensionPoint: " + point);
                this.registerExtensionPoint(point);
            }
        }
        catch (Exception ex) {
            logger.error(bundle + ex.getMessage());
        }
    }

    private void registerExtensionPoint(ExtensionPoint extensionPoint) {
        Collection<IExtension> extensions = extensionPoint.getExtensions();
        ExtensionPoint search = (ExtensionPoint)this.pointMap.get(extensionPoint.getId());
        if (search == null) {
            this.pointMap.put(extensionPoint.getId(), extensionPoint);
        } else if (!extensions.isEmpty()) {
            search.addExtension(extensions);
        }
        ExtensionEvent event = this.getExtensionEvent(extensions, 1);
        this.fireExtensionEvent(event);
    }

    private void removeBundle(Bundle bundle) {
        ArrayList<IExtension> extensionList = new ArrayList<IExtension>();
        String bundleId = bundle.getSymbolicName();
        for (Map.Entry entry : this.pointMap.entrySet()) {
            String version;
            ExtensionPoint search = (ExtensionPoint)entry.getValue();
            List<IExtension> removedList = search.removeExtension(bundleId, version = bundle.getVersion().toString());
            if (removedList == null) continue;
            extensionList.addAll(removedList);
            logger.info("Remove extension(s):" + removedList);
        }
        ExtensionEvent event = this.getExtensionEvent(extensionList, 2);
        this.fireExtensionEvent(event);
    }

    private ExtensionEvent getExtensionEvent(Collection<IExtension> extensionList, int kind) {
        HashMap<String, List<ExtensionDelta>> deltaMap = new HashMap<String, List<ExtensionDelta>>();
        for (IExtension extension : extensionList) {
            List<ExtensionDelta> deltaList;
            String pointId = extension.getExtendPointId();
            if (deltaMap.containsKey(pointId)) {
                deltaList = (List)deltaMap.get(pointId);
            } else {
                deltaList = new ArrayList();
                deltaMap.put(pointId, deltaList);
            }
            deltaList.add(new ExtensionDelta(kind, extension));
        }
        return new ExtensionEvent(deltaMap);
    }

    public void addExtensionListener(IExtensionListener listener) {
        if (this.listenerList.addIfAbsent(listener)) {
            logger.info("Finished adding the listener:" + listener);
        } else {
            logger.info("The listener is already existed:" + listener);
        }
    }

    public void removeExtensionListener(IExtensionListener listener) {
        if (this.listenerList.remove(listener)) {
            logger.info("Finished removing the listener:" + listener);
        } else {
            logger.info("The listener is not existed:" + listener);
        }
    }

    public void clear() {
        this.listenerList.clear();
    }

    private void fireExtensionEvent(ExtensionEvent event) {
        ArrayList<IExtensionListener> invalidList = new ArrayList<IExtensionListener>();
        for (IExtensionListener listener : this.listenerList) {
            String point = listener.getExtensionPointId();
            if (point == null) {
                try {
                    listener.notify(event);
                }
                catch (Exception ex) {
                    logger.error("", (Throwable)ex);
                    invalidList.add(listener);
                }
                continue;
            }
            ExtensionDelta[] deltas = event.getExtensionDeltas(point);
            if (deltas.length <= 0) continue;
            HashMap<String, List<ExtensionDelta>> deltaMap = new HashMap<String, List<ExtensionDelta>>(1);
            deltaMap.put(point, Arrays.asList(deltas));
            try {
                listener.notify(new ExtensionEvent(deltaMap));
            }
            catch (Exception ex) {
                logger.error("", (Throwable)ex);
                invalidList.add(listener);
            }
        }
        for (IExtensionListener listener : invalidList) {
            if (!this.listenerList.remove(listener)) continue;
            logger.info("Finished removing the listener:" + listener);
        }
    }
}

