/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.extension.internal;

import com.huawei.uflight.extension.IExtension;
import com.huawei.uflight.extension.support.OSGiUtils;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Extension
implements IExtension {
    private static Logger logger = LoggerFactory.getLogger(Extension.class);
    private final String pluginId;
    private String pluginVersion;
    private String extendPointId;
    private String pluginRunPath;
    private Element content;

    public Extension(String pluginId, Element content) {
        this.pluginId = pluginId;
        this.content = content;
    }

    @Override
    public String getPluginRunPath() {
        return this.pluginRunPath;
    }

    public void setPluginRunPath(String pluginRunPath) {
        this.pluginRunPath = pluginRunPath;
    }

    @Override
    public String getPluginId() {
        return this.pluginId;
    }

    public Element getContent() {
        return this.content;
    }

    public void setContent(Element content) {
        this.content = content;
    }

    @Override
    public boolean isValid() {
        return this.content != null;
    }

    public void setExtendPointId(String extendPointId) {
        this.extendPointId = extendPointId;
    }

    @Override
    public String getExtendPointId() {
        return this.extendPointId;
    }

    public void setPluginVersion(String pluginVersion) {
        this.pluginVersion = pluginVersion;
    }

    @Override
    public String getPluginVersion() {
        return this.pluginVersion;
    }

    @Override
    public Object createExecutableExtension(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return this.loadClass(className).newInstance();
    }

    @Override
    public <T> T getExtensionObject(Class<T> objClass) {
        String sRootName = this.getXmlRootName(objClass);
        if (sRootName == null) {
            throw new IllegalArgumentException("Class should have annotation @XmlRootElement. class: {}" + objClass.getName());
        }
        Unmarshaller u = null;
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{objClass});
            u = jc.createUnmarshaller();
        }
        catch (JAXBException e) {
            logger.error("Get JAXBContext error", (Throwable)e);
        }
        if (u == null) {
            throw new IllegalArgumentException("Unmarshaller is null");
        }
        Object obj = null;
        try {
            Element node = this.getContent();
            obj = u.unmarshal((Node)node, objClass).getValue();
        }
        catch (JAXBException e) {
            logger.error("Unmarshal error", (Throwable)e);
        }
        return (T)obj;
    }

    @Override
    public <T> T getExtensionObjectUnderExt(Class<T> objClass) {
        Object obj;
        block7: {
            String sRootName = this.getXmlRootName(objClass);
            if (sRootName == null) {
                throw new IllegalArgumentException("Class should have annotation @XmlRootElement. class: {}" + objClass.getName());
            }
            Unmarshaller u = null;
            try {
                JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{objClass});
                u = jc.createUnmarshaller();
            }
            catch (JAXBException e) {
                logger.error("Get JAXBContext error", (Throwable)e);
            }
            if (u == null) {
                throw new IllegalArgumentException("Unmarshaller is null");
            }
            obj = null;
            try {
                if (!this.isValid()) break block7;
                NodeList oNodeList = this.getContent().getChildNodes();
                int cnt = oNodeList.getLength();
                for (int i = 0; i < cnt; ++i) {
                    if (1 != oNodeList.item(i).getNodeType()) continue;
                    obj = u.unmarshal(oNodeList.item(i), objClass).getValue();
                    break;
                }
            }
            catch (JAXBException e) {
                logger.error("Unmarshal error", (Throwable)e);
            }
        }
        return (T)obj;
    }

    private String getXmlRootName(Class<?> objectClass) {
        String sRootName = null;
        XmlType aXmlType = objectClass.getAnnotation(XmlType.class);
        if (aXmlType != null) {
            sRootName = aXmlType.name().equals("##default") ? objectClass.getSimpleName() : aXmlType.name().trim();
        } else {
            XmlRootElement aRootName = objectClass.getAnnotation(XmlRootElement.class);
            if (aRootName == null) {
                return null;
            }
            sRootName = aRootName.name().equals("##default") ? objectClass.getSimpleName() : aRootName.name().trim();
        }
        return sRootName;
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return OSGiUtils.getInstance().loadClass(this.pluginId, this.pluginVersion, className);
    }

    @Override
    public Bundle getBundle() {
        return OSGiUtils.getInstance().getBundle(this.pluginId, this.pluginVersion);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{pluginId=").append(this.pluginId).append(", extendPointId=").append(this.extendPointId).append(", pluginVersion=").append(this.pluginVersion).append(", pluginRunPath=").append(this.pluginRunPath).append("}");
        return builder.toString();
    }

    @Override
    public URL getEntry(String path) {
        return this.getBundle().getEntry(path);
    }
}

