/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.extension;

import com.huawei.uflight.extension.IExtension;
import com.huawei.uflight.extension.support.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExtensionPoint {
    private String id;
    private Map<Pair<String, String>, List<IExtension>> extensionMap;

    public ExtensionPoint(String id) {
        this.id = id;
        this.extensionMap = new HashMap<Pair<String, String>, List<IExtension>>();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Collection<IExtension> getExtensions() {
        ArrayList<IExtension> extensions = new ArrayList<IExtension>();
        for (List<IExtension> e : this.extensionMap.values()) {
            extensions.addAll(e);
        }
        return extensions;
    }

    public Collection<IExtension> getExtension(String pluginId, String pluginVersion) {
        Pair<String, String> pluginTuple = new Pair<String, String>(pluginId, pluginVersion);
        if (this.extensionMap.containsKey(pluginTuple)) {
            return this.extensionMap.get(pluginTuple);
        }
        return new ArrayList<IExtension>();
    }

    public List<IExtension> removeExtension(String pluginId, String pluginVersion) {
        return this.extensionMap.remove(new Pair<String, String>(pluginId, pluginVersion));
    }

    public void addExtension(IExtension extension) {
        Pair<String, String> pluginTuple = new Pair<String, String>(extension.getPluginId(), extension.getPluginVersion());
        if (this.extensionMap.containsKey(pluginTuple)) {
            List<IExtension> extensions = this.extensionMap.get(pluginTuple);
            extensions.add(extension);
        } else {
            ArrayList<IExtension> extensions = new ArrayList<IExtension>(1);
            extensions.add(extension);
            this.extensionMap.put(pluginTuple, extensions);
        }
    }

    public void addExtension(Collection<IExtension> exts) {
        for (IExtension ext : exts) {
            this.addExtension(ext);
        }
    }

    public boolean hasExtension() {
        return !this.extensionMap.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ExtensionPoint[");
        sb.append("id=").append(this.id).append(" ");
        sb.append("extensionMap=").append(this.extensionMap).append(" ");
        return sb.append("]").append(super.toString()).toString();
    }
}

