/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.event.process.impl;

import com.huawei.uflight.appmanager.api.AppEntity;
import com.huawei.uflight.appmanager.api.DeploymentMode;
import com.huawei.uflight.appmanager.api.IAppManager;
import com.huawei.uflight.appmanager.api.IAppStateChanageListener;
import com.huawei.uflight.event.Activator;
import com.huawei.uflight.event.process.IProcessInfoHolder;
import com.huawei.uflight.event.process.ProcessInfo;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProcessInfoHolder
implements IProcessInfoHolder {
    private ConcurrentHashMap<String, ProcessInfo> processCache = new ConcurrentHashMap();
    private Set<ProcessInfo> allProcess = new CopyOnWriteArraySet<ProcessInfo>();
    private IAppStateChanageListener listener;
    private IAppManager appMgr;
    private static final Logger logger = LoggerFactory.getLogger(DefaultProcessInfoHolder.class);

    @Override
    public void start() {
        ServiceReference reference = Activator.getBundleContext().getServiceReference(IAppManager.class.getName());
        if (null == reference) {
            throw new IllegalStateException("can not find the appmanager service");
        }
        this.appMgr = (IAppManager)Activator.getBundleContext().getService(reference);
        if (null == this.appMgr) {
            throw new IllegalStateException("can not find the appmanager service");
        }
        this.listener = new AppStateChangeListener();
        this.appMgr.addAppStateChangeListener(this.listener, new String[0]);
    }

    @Override
    public void stop() {
        this.appMgr.removeAppStateChangeListener(this.listener, new String[0]);
    }

    @Override
    public ProcessInfo getCurrentProcessInfo(Class clz) {
        Bundle bundle = FrameworkUtil.getBundle((Class)clz);
        if (null == bundle) {
            logger.error("can not find the bundle of clz : " + clz.getName());
            return null;
        }
        AppEntity app = this.appMgr.getAppByBundle(bundle);
        if (this.processCache.containsKey(app.getAppName())) {
            return this.processCache.get(app.getAppName());
        }
        ProcessInfo procInfo = new ProcessInfo(app.getProcID(), app.getProcHandle());
        this.allProcess.add(procInfo);
        this.processCache.put(app.getAppName(), procInfo);
        return procInfo;
    }

    @Override
    public boolean isLocalProcess(ProcessInfo info) {
        return this.allProcess.contains(info);
    }

    @Override
    public Iterator<ProcessInfo> getLocalProcessIter() {
        return this.allProcess.iterator();
    }

    @Override
    public int getDepolyMode() {
        if (null == this.appMgr) {
            return 1;
        }
        if (this.appMgr.getDeploymentMode() == DeploymentMode.independent) {
            return 1;
        }
        return 0;
    }

    private class AppStateChangeListener
    implements IAppStateChanageListener {
        private AppStateChangeListener() {
        }

        public void preStateChanged(AppEntity app, AppEntity.AppState oldState, AppEntity.AppState newState) {
        }

        public void postStateChanged(AppEntity app, AppEntity.AppState oldState, AppEntity.AppState newState) {
            if (AppEntity.AppState.started != newState && DefaultProcessInfoHolder.this.processCache.containsKey(app.getAppName())) {
                ProcessInfo procInfo = (ProcessInfo)DefaultProcessInfoHolder.this.processCache.remove(app.getAppName());
                DefaultProcessInfoHolder.this.allProcess.remove(procInfo);
            }
        }
    }
}

