/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.event.client.impl.support;

import com.huawei.uflight.event.client.EventResponse;
import com.huawei.uflight.event.client.IEventCallback;
import com.huawei.uflight.event.client.impl.NoReentryObserver;
import com.huawei.uflight.event.client.impl.support.DeadLineTask;
import com.huawei.uflight.event.client.impl.support.TimerQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scheduler {
    private static Logger logger = LoggerFactory.getLogger(Scheduler.class);
    private ExecutorService m_executor;
    private TimerQueue m_timerQueue;

    public Scheduler(ExecutorService executor, TimerQueue timerQueue) {
        this.m_executor = executor;
        this.m_timerQueue = timerQueue;
    }

    public void scheduleTask(Runnable task) {
        this.m_executor.submit(task);
    }

    public EventResponse scheduleSyncTask(Callable<EventResponse> task, int timeout) {
        Future<EventResponse> future = this.m_executor.submit(new DeadLineTask(task, System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(timeout)));
        EventResponse result = null;
        try {
            result = future.get(timeout, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.error("scheduleSyncTask fault , task is" + task, (Throwable)e);
            return new EventResponse(-3);
        }
        return result;
    }

    public void scheduleTask(Callable<EventResponse> task, int timeout, IEventCallback observer) {
        final NoReentryObserver localObserver = new NoReentryObserver(observer);
        long deadTime = System.currentTimeMillis() + (long)(timeout * 1000);
        this.m_executor.submit(new DeadLineTask(task, deadTime, localObserver));
        this.m_timerQueue.scheduleTimer(new Runnable(){

            @Override
            public void run() {
                localObserver.handleResponse(new EventResponse(-3));
            }
        }, TimeUnit.SECONDS.toMillis(timeout));
    }

    public void stop() {
        this.m_executor.shutdown();
        this.m_timerQueue.stop();
    }
}

