/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.event.client.impl.support;

import com.huawei.uflight.event.client.EventResponse;
import com.huawei.uflight.event.client.IEventCallback;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeadLineTask
implements Callable<EventResponse> {
    private IEventCallback observer = null;
    private static Logger logger = LoggerFactory.getLogger(DeadLineTask.class);
    private final long deadLine;
    private Callable<EventResponse> task;

    public DeadLineTask(Callable<EventResponse> task, long deadline, IEventCallback observer) {
        this.task = task;
        this.deadLine = deadline;
        this.observer = observer;
    }

    public DeadLineTask(Callable<EventResponse> task, long deadline) {
        this(task, deadline, null);
    }

    @Override
    public EventResponse call() throws Exception {
        EventResponse result = null;
        if (System.currentTimeMillis() >= this.deadLine) {
            result = new EventResponse(-3);
            logger.error("scheduler is busy, task was discarded");
            if (this.observer != null) {
                this.observer.handleResponse(result);
            }
        } else {
            try {
                result = this.task.call();
            }
            catch (Exception ex) {
                logger.error("task call Exception", (Throwable)ex);
                if (this.observer != null) {
                    this.observer.handleResponse(new EventResponse(-4));
                }
                return new EventResponse(-4);
            }
        }
        if (this.observer != null) {
            this.observer.handleResponse(result);
        }
        return result;
    }
}

