/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.event.client.impl.jms;

import com.huawei.uflight.event.client.EventResponse;
import com.huawei.uflight.event.client.IEvent;
import com.huawei.uflight.event.client.impl.jms.JMSMessage;
import com.huawei.uflight.event.process.ProcessInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSMessageHelper {
    private static final String MSG_BODY = "body";
    private static Logger logger = LoggerFactory.getLogger(JMSMessageHelper.class);

    public static HashMap<String, Object> decodeControlMsg(Message nativeMsg) {
        HashMap ret = null;
        if (nativeMsg instanceof ObjectMessage) {
            ObjectMessage obMsg = (ObjectMessage)nativeMsg;
            Serializable ob = null;
            try {
                ob = obMsg.getObject();
            }
            catch (JMSException e) {
                logger.error("decodeControlMsg fail\u00a3\u00ac nativeMsg =" + nativeMsg, (Throwable)e);
            }
            if (ob != null && ob instanceof HashMap) {
                ret = (HashMap)ob;
            }
        }
        return ret;
    }

    public static JMSMessage decodeProtocolMsg(Message nativeMsg) {
        JMSMessage msg = null;
        if (!(nativeMsg instanceof MapMessage)) {
            logger.error("decodeProtocolMsg failed , legal is MapMessage" + nativeMsg);
            return null;
        }
        MapMessage mapMsg = (MapMessage)nativeMsg;
        try {
            byte[] buf = mapMsg.getBytes(MSG_BODY);
            ByteArrayInputStream byteIn = new ByteArrayInputStream(buf);
            ObjectInputStream obIn = new ObjectInputStream(byteIn);
            Object ob = obIn.readObject();
            if (ob instanceof JMSMessage) {
                msg = (JMSMessage)ob;
            }
        }
        catch (Exception e) {
            logger.error("decodeProtocolMsg failed ,nativeMsg =" + nativeMsg + e);
            return msg;
        }
        if (null != msg) {
            try {
                msg.setErrorCode(mapMsg.getInt("errorCode"));
            }
            catch (JMSException e) {
                logger.error("decodeProtocolMsg failed : " + (Object)((Object)e));
            }
        }
        return msg;
    }

    public static void encodeProtocolMsg(JMSMessage msg, MapMessage mapMsg) throws JMSException {
        mapMsg.setLong("magicCode", -8390908261146750265L);
        mapMsg.setInt("ne", msg.getNeID());
        mapMsg.setInt("type", msg.getType());
        mapMsg.setString("topic", msg.getTopic());
        mapMsg.setString("responseTopic", msg.getResponseTopic());
        mapMsg.setLong("eventID", msg.getEventID());
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream obWriter = new ObjectOutputStream(out);
            obWriter.writeObject(msg);
            obWriter.close();
            out.close();
            byte[] bys = out.toByteArray();
            mapMsg.setBytes(MSG_BODY, bys);
        }
        catch (IOException ex) {
            logger.error("encodeProtocolMsg failed : mapMsg = " + mapMsg + ex);
        }
    }

    public static byte[] encode(Object ob) {
        byte[] ret = null;
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(buf);
            out.writeObject(ob);
            ret = buf.toByteArray();
        }
        catch (IOException e) {
            logger.error("encode object failed : ", (Throwable)e);
        }
        return ret;
    }

    public static Object decode(byte[] buf) {
        ByteArrayInputStream arrayIn = new ByteArrayInputStream(buf);
        Object ob = null;
        try {
            ObjectInputStream in = new ObjectInputStream(arrayIn);
            ob = in.readObject();
        }
        catch (Exception e) {
            logger.error("decode object failed : ", (Throwable)e);
        }
        return ob;
    }

    public static IEvent getRequest(JMSMessage msg) {
        Object o = JMSMessageHelper.decode(msg.getRequest());
        if (o != null) {
            return (IEvent)o;
        }
        return null;
    }

    public static EventResponse getResponse(JMSMessage msg) {
        Object o = JMSMessageHelper.decode(msg.getResponse());
        if (o != null) {
            return (EventResponse)o;
        }
        return null;
    }

    public static JMSMessage newRequestMsg(IEvent request, int timeout, ProcessInfo dest) {
        JMSMessage msg = new JMSMessage(1, request.getNeID());
        msg.setTopic(request.getTopic());
        msg.setRequest(JMSMessageHelper.encode(request));
        JMSMessageHelper.setDest(msg, dest);
        msg.setCommitTime(System.currentTimeMillis());
        msg.setTimeout(timeout);
        return msg;
    }

    public static JMSMessage newRequestMsg(IEvent request, int timeout) {
        return JMSMessageHelper.newRequestMsg(request, timeout, null);
    }

    public static JMSMessage newNotifyMsg(IEvent request) {
        JMSMessage msg = new JMSMessage(2, request.getNeID());
        msg.setTopic(request.getTopic());
        msg.setRequest(JMSMessageHelper.encode(request));
        return msg;
    }

    public static JMSMessage newResponseMsg(JMSMessage request, EventResponse response, ProcessInfo sendPorc) {
        JMSMessage responseMsg = new JMSMessage(3, request.getNeID());
        responseMsg.setResponse(JMSMessageHelper.encode(response));
        responseMsg.setCommitTime(request.getCommitTime());
        if (sendPorc != null) {
            JMSMessageHelper.setDest(responseMsg, sendPorc);
        } else {
            responseMsg.setProc(request.getProc());
            responseMsg.setProcHandle(request.getProcHandle());
        }
        responseMsg.setRequest(request.getRequest());
        responseMsg.setResponseTopic(request.getResponseTopic());
        responseMsg.setTimeout(request.getTimeout());
        responseMsg.setTopic(request.getTopic());
        responseMsg.setResponseTopic(request.getResponseTopic());
        responseMsg.setEventID(request.getEventID());
        return responseMsg;
    }

    private static void setDest(JMSMessage msg, ProcessInfo dest) {
        if (dest != null && msg != null) {
            msg.setProc(dest.getProcID());
            msg.setProcHandle(dest.getProcHandle());
        }
    }
}

